% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_dti_tck.R
\name{read.dti.tsf}
\alias{read.dti.tsf}
\title{Read DTI tracking per-coord data from file in MRtrix 'TSF' format.}
\usage{
read.dti.tsf(filepath)
}
\arguments{
\item{filepath}{character string, path to the \code{TSF} file to read.}
}
\value{
named list with entries 'header' and 'scalars'. The scala data are available in 2 representations: 'merged': a vector of all values (requires external knowledge on track borders), and 'scalar_list': organized into a list of vectors. Each vector represents the values for the points of one track.
}
\description{
Read DTI tracking per-coord data from file in MRtrix 'TSF' format.
}
\note{
The data in such a file is one value per track point, the tracks are not part of the file but come in the matching TCK file.
}
\examples{
\dontrun{
 tsff = "~/simple.tsf";
 tsf = read.dti.tsf(tsff);
}

}
\seealso{
\code{read.dti.tck}
}
