% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_fs_surface.R
\name{write.fs.surface.asc}
\alias{write.fs.surface.asc}
\title{Write mesh to file in FreeSurfer ASCII surface format}
\usage{
write.fs.surface.asc(filepath, vertex_coords, faces)
}
\arguments{
\item{filepath}{string. Full path to the output surface file, should end with '.asc', but that is not enforced.}

\item{vertex_coords}{n x 3 matrix of doubles. Each row defined the x,y,z coords for a vertex.}

\item{faces}{n x 3 matrix of integers. Each row defined the 3 vertex indices that make up the face. WARNING: Vertex indices should be given in R-style, i.e., the index of the first vertex is 1. However, they will be written in FreeSurfer style, i.e., all indices will have 1 substracted, so that the index of the first vertex will be zero.}
}
\value{
string the format that was written. One of "tris" or "quads". Currently only triangular meshes are supported, so always 'tris'.
}
\description{
Write vertex coordinates and vertex indices defining faces to a file in FreeSurfer ASCII surface format.
   For a subject (MRI image pre-processed with FreeSurfer) named 'bert', an example file would be 'bert/surf/lh.white.asc'.
}
\examples{
\donttest{
    # Read a surface from a file:
    surface_file = system.file("extdata", "lh.tinysurface",
     package = "freesurferformats", mustWork = TRUE);
    mesh = read.fs.surface(surface_file);

    # Now save it:
    write.fs.surface.asc(tempfile(fileext=".asc"), mesh$vertices, mesh$faces);
}

}
\seealso{
Other mesh functions: \code{\link{read.fs.surface.asc}},
  \code{\link{read.fs.surface}},
  \code{\link{read_nisurfacefile}},
  \code{\link{read_nisurface}},
  \code{\link{write.fs.surface}}
}
\concept{mesh functions}
