% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_group_n.R
\name{get_group_n}
\alias{get_group_n}
\title{Formatted Group Sample Size for Tables}
\usage{
get_group_n(.data, ...)
}
\arguments{
\item{.data}{A data frame or tibble}

\item{...}{A dplyr::filter expression. Used to select subgroup.}
}
\value{
A character string
}
\description{
Given a tibble and a filter expression, get_group_n returns
  the group sample size formatted as "N = XXXX". Made to work in a dplyr
  pipeline, and used when creating tables for publications / reports.
}
\examples{
library(dplyr)
library(freqtables)

data(mtcars)

# Get sample size for cars with 4 cylinders
mtcars \%>\% get_group_n(cyl == 4)

#> [1] "N = 11"
}
