% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/call.R
\name{call_conditionally}
\alias{call_conditionally}
\title{Call a Function Conditionally}
\usage{
call_conditionally(f, condition, fallback, ..., harden = FALSE)
}
\arguments{
\item{f}{The function passed to \code{\link{do.call}}.}

\item{condition}{An expression.}

\item{fallback}{See \emph{Description}.}

\item{...}{arguments passed to \code{\link{do.call}}.}

\item{harden}{Set to \code{\link{TRUE}} to return \code{fallback} if
\code{\link{do.call}} fails.}
}
\value{
The return value of \code{f} or \code{fallback}.
}
\description{
\pkg{whoami} 1.3.0 uses things like
\code{system("getent passwd $(whoami)", intern = TRUE)}
which I can not \code{\link{tryCatch}}, as it gives no error nor warning.
So this function returns a fallback if the condition given is not
\code{\link{TRUE}}.
}
\examples{
call_conditionally(get_package_version,
                   condition = TRUE,
                   args = list(x = "fritools"),
                   fallback = "0.0")
call_conditionally(get_package_version,
                   condition = FALSE,
                   args = list(x = "fritools"),
                   fallback = "0.0")
call_conditionally(get_package_version,
                   condition = TRUE,
                   args = list(x = "not_there"),
                   harden = TRUE,
                   fallback = "0.0")
}
\seealso{
Other call functions.: 
\code{\link{call_safe}()}
}
\concept{call functions.}
