% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz_centsums.R
\docType{class}
\name{centcosums-class}
\alias{centcosums}
\alias{centcosums-class}
\alias{initialize,centcosums-class}
\alias{initialize,centcosums-method}
\title{centcosums Class.}
\usage{
\S4method{initialize}{centcosums}(.Object, cosums, order = NA_real_)

centcosums(cosums, order = NULL)
}
\arguments{
\item{.Object}{a \code{centcosums} object, or proto-object.}

\item{cosums}{the output of \code{\link{cent_cosums}}, say.}

\item{order}{the order, defaulting to \code{2}.}
}
\value{
An object of class \code{centcosums}.
}
\description{
An S4 class to store (centered) cosums of data, and to support operations on 
the same.
}
\details{
A \code{centcosums} object contains a multidimensional array (now only
2-diemnsional), as output by \code{cent_cosums}.
}
\section{Slots}{

\describe{
\item{\code{cosums}}{a multidimensional array of the cosums.}

\item{\code{order}}{the maximum order. ignored for now.}
}}
\note{
The moment computations provided by fromo are 
numerically robust, but will often \emph{not} provide the
same results as the 'standard' implementations,
due to differences in roundoff. We make every attempt to balance
speed and robustness. User assumes all risk from using
the fromo package.
}
\examples{
obj <- new("centcosums",cosums=cent_cosums(matrix(rnorm(100*3),ncol=3),max_order=2),order=2)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Terriberry, T. "Computing Higher-Order Moments Online."
\url{http://people.xiph.org/~tterribe/notes/homs.html}

J. Bennett, et. al., "Numerically Stable, Single-Pass, 
Parallel Statistics Algorithms," Proceedings of IEEE
International Conference on Cluster Computing, 2009.
\url{https://www.semanticscholar.org/paper/Numerically-stable-single-pass-parallel-statistics-Bennett-Grout/a83ed72a5ba86622d5eb6395299b46d51c901265}

Cook, J. D. "Accurately computing running variance."
\url{http://www.johndcook.com/standard_deviation.html}

Cook, J. D. "Comparing three methods of computing 
standard deviation."
\url{http://www.johndcook.com/blog/2008/09/26/comparing-three-methods-of-computing-standard-deviation}
}
\seealso{
cent_cosums
}
\keyword{moments}

