% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_locations.R
\name{get_locations}
\alias{get_locations}
\title{Get metadata for the location names defined in the Frost API}
\usage{
get_locations(client_id,
              names = NULL,
              geometry = NULL,
              fields = NULL,
              return_response = FALSE)
}
\arguments{
\item{client_id}{A string. The client ID to use to send requests to the
Frost API.}

\item{names}{A character vector. The location names that you want
metadata for.}

\item{geometry}{A string. Get Frost API location names defined by a
specified geometry. Geometries are specified as either "nearest(POINT(...))"
or "POLYGON(...)" using well-known text representation for geometry (WKT).}

\item{fields}{A character vector. Fields to include in the response (i.e.
output). If this parameter is specified, then only these fields are
returned in the response. If not specified, then all fields will be
returned in the response.}

\item{return_response}{A logical. If set to \code{TRUE}, then the function
returns the response from the GET request. If set to \code{FALSE} (default),
then the function returns a tibble (data frame) of the content in the
response.}
}
\value{
The function returns either a data frame with metadata about
location names, or the response of the GET request, depending on the
boolean value set for \code{return_response}.
}
\description{
\code{get_locations()} retrieves metadata about location names
defined for use in the Frost API. The function requires an
input for \code{client_id}. The other function arguments are optional, and
default to \code{NULL}, which means that the response from the API is not
filtered on these parameters.
}
\examples{
\donttest{
client.id <- "<YOUR CLIENT ID>"

# Get all location names
locations.df <- get_locations(client_id = client.id)
}

}
