% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path_filter}
\alias{path_filter}
\title{Filter paths}
\usage{
path_filter(path, glob = NULL, regexp = NULL, invert = FALSE, ...)
}
\arguments{
\item{path}{A character vector of one or more paths.}

\item{glob}{A wildcard aka globbing pattern (e.g. \verb{*.csv}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{regexp}{A regular expression (e.g. \verb{[.]csv$}) passed on to \code{\link[=grep]{grep()}} to filter paths.}

\item{invert}{If \code{TRUE} return files which do \emph{not} match}

\item{...}{Additional arguments passed to \link{grep}.}
}
\description{
Filter paths
}
\examples{
path_filter(c("foo", "boo", "bar"), glob = "*oo")
path_filter(c("foo", "boo", "bar"), glob = "*oo", invert = TRUE)

path_filter(c("foo", "boo", "bar"), regexp = "b.r")
}
