% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis.R
\name{vis.data.on.fsaverage}
\alias{vis.data.on.fsaverage}
\title{Visualize arbitrary data on the fsaverage template subject, if available.}
\usage{
vis.data.on.fsaverage(subjects_dir = NULL,
  vis_subject_id = "fsaverage", morph_data_lh, morph_data_rh,
  surface = "white", colormap = squash::jet, views = c("t4"),
  rgloptions = list())
}
\arguments{
\item{subjects_dir, }{string or NULL. The FreeSurfer SUBJECTS_DIR, containing the subdir of vis_subject_id, the subject that you want to use for visualization. If NULL, this function tries to determine it automatically from environment variables. If they are not set, an error is raised.}

\item{vis_subject_id, }{string. The subject identifier from which to obtain the surface for data visualization. Defaults to 'fsaverage'.}

\item{morph_data_lh, }{numeric vector or NULL, the data to visualize on the left hemisphere surface. Must have the same length as the lh surface of the vis_subject_id has vertices. If NULL, this surface will not be rendered. Only one of morph_data_lh or morph_data_rh is allowed to be NULL.}

\item{morph_data_rh, }{numeric vector or NULL, the data to visualize on the right hemisphere surface. Must have the same length as the rh surface of the vis_subject_id has vertices. If NULL, this surface will not be rendered. Only one of morph_data_lh or morph_data_rh is allowed to be NULL.}

\item{surface, }{string. The display surface. E.g., "white", "pial", or "inflated". Defaults to "white".}

\item{colormap, }{a colormap. See the squash package for some colormaps. Defaults to squash::jet.}

\item{views, }{list of strings. Valid entries include: 'si': single interactive view. 't4': tiled view showing the brain from 4 angles. 't9': tiled view showing the brain from 9 angles.}

\item{rgloptions}{option list passed to [rgl::par3d()]. Example: rgloptions = list("windowRect"=c(50,50,1000,1000));}
}
\value{
list of coloredmeshes. The coloredmeshes used for the visualization.
}
\description{
Creates a surface mesh, applies a colormap transform the morphometry data values into colors, and renders the resulting colored mesh in an interactive window. If hemi is 'both', the data is rendered for the whole brain. This function tries to automatically retrieve the subjects dir of the fsaverage template subject by checking the environment variables SUBJECTS_DIR and FREESURFER_HOME for the subject. The subject is required for its surfaces, which are not shipped with this package for licensing reasons.
}
\seealso{
Other visualization functions: \code{\link{vis.data.on.subject}},
  \code{\link{vis.subject.annot}},
  \code{\link{vis.subject.morph.native}}
}
\concept{visualization functions}
