% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_volume.R
\name{cubes3D.tris}
\alias{cubes3D.tris}
\title{Vectorized version of cube3D.tris}
\usage{
cubes3D.tris(centers, edge_length = 1)
}
\arguments{
\item{centers}{numerical matrix with 3 columns. Each column represents the x, y, z coordinates of a center at which to create a cube.}

\item{edge_length}{numerical vector or scalar, the edge length. Must have length 1 (same edge length for all cubes), or the length must be identical to the number of rows in parameter `centers`.}
}
\value{
matrix of triangle coordinates, see \code{\link[fsbrain]{cube3D.tris}}.
}
\description{
Vectorized version of cube3D.tris
}
\examples{
   # Plot a 3D cloud of 20000 voxels:
   centers = matrix(rnorm(20000*3)*100, ncol=3);
   rgl::triangles3d(cubes3D.tris(centers));

}
