% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vis_meshes.R
\name{vis.coloredmeshes}
\alias{vis.coloredmeshes}
\title{Visualize a list of colored meshes in a single scene.}
\usage{
vis.coloredmeshes(
  coloredmeshes,
  background = "white",
  skip_all_na = TRUE,
  style = "default",
  rgloptions = rglo(),
  rglactions = list(),
  draw_colorbar = FALSE
)
}
\arguments{
\item{coloredmeshes}{list of coloredmesh. A coloredmesh is a named list as returned by the coloredmesh.from.* functions. It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh.}

\item{background}{string, background color passed to rgl::bg3d()}

\item{skip_all_na}{logical, whether to skip (i.e., not render) meshes in the list that have the property 'render' set to FALSE. Defaults to TRUE. Practically, this means that a hemisphere for which the data was not given is not rendered, instead of being rendered in a single color.}

\item{style, }{a named list of style parameters or a string specifying an available style by name (e.g., 'shiny'). Defaults to 'default', the default style.}

\item{rgloptions}{option list passed to \code{\link{par3d}}. Example: \code{rgloptions = list("windowRect"=c(50,50,1000,1000))};}

\item{rglactions}{named list. A list in which the names are from a set of pre-defined actions. Defaults to the empty list.}

\item{draw_colorbar}{logical. Whether to draw a colorbar. WARNING: Will only show up if there is enough space in the plot area and does not resize properly. Defaults to FALSE. See \code{\link[fsbrain]{coloredmesh.plot.colorbar.separate}} for an alternative.}
}
\value{
the list of visualized coloredmeshes
}
\description{
Visualize a list of colored meshes in a single scene.
}
\note{
To change or adapt the colorbar, you should use the makecmap_options parameter when constructing them in a vis function. See the example.
}
\examples{
\donttest{
   fsbrain::download_optional_data();
   subjects_dir = fsbrain::get_optional_data_filepath("subjects_dir");
   cm = vis.subject.morph.native(subjects_dir, 'subject1', 'thickness',
    makecmap_options=list('n'=100, 'colFn'=viridis::viridis));
   # You could mess with the meshes here.
   vis.coloredmeshes(cm);
}

}
