% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/brainview_magick.R
\name{vis.export.from.coloredmeshes}
\alias{vis.export.from.coloredmeshes}
\title{Export high-quality brainview image with a colorbar.}
\usage{
vis.export.from.coloredmeshes(
  coloredmeshes,
  colorbar_legend = NULL,
  img_only = TRUE,
  horizontal = TRUE,
  silent = TRUE,
  quality = 1L,
  output_img = "fsbrain_arranged.png",
  image.plot_extra_options = NULL,
  large_legend = TRUE,
  view_angles = get.view.angle.names(angle_set = "t4"),
  style = "default",
  grid_like = TRUE,
  background_color = "white",
  transparency_color = NULL,
  ...
)
}
\arguments{
\item{coloredmeshes}{list of coloredmesh. A coloredmesh is a named list as returned by the `coloredmesh.from*` functions (like \code{\link{coloredmesh.from.morph.native}}). It has the entries 'mesh' of type tmesh3d, a 'col', which is a color specification for such a mesh. The `vis*` functions (like \code{\link[fsbrain]{vis.subject.morph.native}}) all return a list of coloredmeshes.}

\item{colorbar_legend}{character string or NULL, the title for the colorbar.}

\item{img_only}{logical, whether to return only the resulting image}

\item{horizontal}{logical, whether to plot the colorbar horizontally (TRUE) or vertically (FALSE). Pass 'NULL' to force no colorbar at all.}

\item{silent}{logical, whether to suppress messages}

\item{quality}{integer, an arbitrary quality. This is the resolution per tile before trimming, divided by 1000, in pixels. Example: 1L means 1000x1000 pixels per tile before trimming. Currently supported values: \code{1L..2L}. Note that the resolution you can get is also limited by your screen resolution.}

\item{output_img}{string, path to the output file. Defaults to "fsbrain_arranged.png"}

\item{image.plot_extra_options}{named list, custom options for fields::image.plot. Overwrites those derived from the quality setting. If in doubt, leave this alone.}

\item{large_legend}{logical, whether to plot extra large legend text, affects the font size of the colorbar_legend and the tick labels.}

\item{view_angles}{list of strings. See \code{\link{get.view.angle.names}} for all valid strings.}

\item{style}{the rendering style, see \code{material3d} or use a predefined style like 'default' or 'shiny'.}

\item{grid_like}{logical, passed to \code{vislayout.from.coloredmeshes}.}

\item{background_color}{hex color string (like '#FFFFFF'), the color to use for the background. Ignored if 'transparency_color' is not NULL. To get a transparent background, use 'transparency_color' instead of this parameter. WARNING: Do not use color names (like 'gray'), as their interpretation differs between rgl and image magick!}

\item{transparency_color}{hex color string (like '#FFFFFF'), the temporary background color that will get mapped to transparency, or NULL if you do not want a transparent background. If used, it can be any color that does not occur in the foreground. Try '#FFFFFF' (white) or '#000000' (black) if in doubt. WARNING: Do not use color names (like 'gray'), as their interpretation differs between rgl and image magick!}

\item{...}{extra arguments passed to \code{vislayout.from.coloredmeshes}.}
}
\value{
magick image instance or named list, depending on the value of 'img_only'. If the latter, the list contains the fields 'rev_vl', 'rev_cb', and 'rev_ex', which are the return values of the functions \code{vislayout.from.coloredmeshes}, \code{coloredmesh.plot.colorbar.separate}, and {combine.colorbar.with.brainview.image}, respectively.
}
\description{
This function serves as an easy (but slightly inflexible) way to export a high-quality, tight-layout, colorbar figure to disk. If no colorbar is required, one can use \code{vislayout.from.coloredmeshes} instead.
}
\note{
Note that your screen resolution has to be high enough to generate the final image in the requested resolution, see the 'fsbrain FAQ' vignette for details and solutions if you run into trouble.
}
\examples{
\dontrun{
    rand_data = rnorm(327684, 5, 1.5);
    cm = vis.data.on.fsaverage(morph_data_both=rand_data,
      rglactions=list('no_vis'=T));
    vis.export.from.coloredmeshes(cm, colorbar_legend='Random data',
      output_img="~/fsbrain_arranged.png");
}

}
\seealso{
This function should not be used anymore, it will be deprecated soon. Please use the \code{\link[fsbrain]{export}} function instead.
}
