% Generated by roxygen2 (4.0.2): do not edit by hand
\name{fslcog}
\alias{fslcog}
\title{Image Center of Gravity (FSL)}
\usage{
fslcog(img, mm = TRUE, verbose = TRUE)
}
\arguments{
\item{img}{Object of class nifti, or path of file}

\item{mm}{Logical if the center of gravity (COG) would be in mm (default \code{TRUE})
or voxels (\code{FALSE})}

\item{verbose}{(logical) print out command before running}
}
\value{
Vector of length 3
}
\description{
Find Center of Gravity of Image from FSL
}
\note{
FSL uses a 0-based indexing system, which will give you a different
answer compared to \code{cog}, but \code{fslcog(img, mm = FALSE) +1}
should be relatively close to \code{cog(img)}
}
\examples{
if (have.fsl()){
x = array(rnorm(1e6), dim = c(100, 100, 100))
img = nifti(x, dim= c(100, 100, 100),
datatype = convert.datatype()$FLOAT32, cal.min = min(x),
cal.max = max(x), pixdim = rep(1, 4))
fslcog(img)
}
}

