% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsl_swapdim.R, R/fslhd.R
\name{fsl_swapdim}
\alias{fsl_swapdim}
\alias{fslswapdim}
\title{FSL Swap Dimensions}
\usage{
fsl_swapdim(..., outfile = tempfile(fileext = ".nii.gz"),
  retimg = FALSE)

fslswapdim(file, outfile = NULL, retimg = TRUE, reorient = FALSE,
  intern = FALSE, a = "x", b = "y", c = "z", verbose = TRUE, ...)
}
\arguments{
\item{...}{additional arguments passed to \code{\link{readnii}}.}

\item{outfile}{(character) resultant image name (optional)}

\item{retimg}{(logical) return image of class nifti}

\item{file}{(character) image to be manipulated}

\item{reorient}{(logical) If retimg, should file be reoriented when read in?
Passed to \code{\link{readnii}}.}

\item{intern}{(logical) to be passed to \code{\link{system}}}

\item{a}{(character) Option for x domain in \code{fslswapdim}}

\item{b}{(character) Option for y domain in \code{fslswapdim}}

\item{c}{(character) Option for z domain in \code{fslswapdim}}

\item{verbose}{(logical) print out command before running}
}
\value{
If \code{retimg} then object of class nifti.  Otherwise,
Result from system command, depends if intern is TRUE or FALSE.
}
\description{
This function calls \code{fslswapdim}
}
\note{
Functions with underscores have different defaults
and will return an output filename, so to be used for piping
}
