% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mridefacer.R
\name{mridefacer}
\alias{mridefacer}
\alias{get_mridefacer_mask}
\title{MRI Defacer}
\usage{
mridefacer(file, ..., verbose = TRUE)

get_mridefacer_mask(file, brain_mask = NULL, bet_opts = "-f 0.5",
  search_radius = 90, opts = NULL, template_brain = NULL,
  template_brain_weight = NULL, template_biometric_mask = NULL,
  verbose = TRUE)
}
\arguments{
\item{file}{input file image to remove face/ears}

\item{...}{not used}

\item{verbose}{print diagnostic messages.  If \code{> 1}, more verbose}

\item{brain_mask}{brain mask of file.  If \code{NULL}, \code{\link{fslbet}}
will be applied}

\item{bet_opts}{options to pass to  \code{\link{fslbet}} if applied}

\item{search_radius}{search radius option to pass to \code{\link{flirt}}}

\item{opts}{additional options to pass to \code{\link{flirt}}}

\item{template_brain}{template brain image, may be \code{NULL}}

\item{template_brain_weight}{template brain weight image, used
for registration may be \code{NULL}}

\item{template_biometric_mask}{template biometric mask.  Everything that 
is wanted should be \code{1},  may be \code{NULL}}
}
\value{
A character filename of the output image
}
\description{
MRI Defacer
}
\note{
Adapted from 
\url{https://github.com/mih/mridefacer}
}
\examples{
if (have_fsl()) {
file = "~/Downloads/sample_T1_input.nii.gz"
if (file.exists(file)) {
    res = mridefacer(file)
}
}
}
