% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic_functions.R
\name{as_tibble.pgeometry}
\alias{as_tibble.pgeometry}
\alias{as.data.frame.pgeometry}
\title{Convert a \code{pgeometry} object into tabular data (\code{data.frame} or \code{tibble})}
\usage{
\method{as_tibble}{pgeometry}(x, ...)

\method{as.data.frame}{pgeometry}(x, ...)
}
\arguments{
\item{x}{A \code{pgeometry} object.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Unused.}
}
\value{
A tabular object (\code{data.frame} or \code{tibble}) with the number of rows corresponding to the number of components of
the \code{pgeometry} object given as input and two columns in the format \verb{(geometry, md)}.
}
\description{
These functions convert a \code{pgeometry} object into a tabular format, such as a \code{tibble} or \code{data.frame} object,
where the components of the \code{pgeometry} object compose the rows of the table.
}
\details{
These functions are S3 methods for \code{pgeometry}.
The \code{as_tibble()} function converts a \code{pgeometry} object into a \code{tibble}, which is a data frame with class \code{tbl_df}.
This allows us to get the internal components of the \code{pgeometry} object
(i.e., spatial features objects and membership degrees) as a data frame with
two separate columns: (i) \code{geometry} (an \code{sfc} object) and (ii) \code{md} (\emph{membership degree}).
Therefore, each row of this tibble represents a component of the original \code{pgeometry} object.

It is also possible to call the S3 method \code{as.data.frame()} to convert a \code{pgeometry} object into a \code{data.frame} object.
}
\examples{
pcomp1 <- create_component("MULTIPOINT(1 2, 3 2)", 0.4)
pcomp2 <- create_component("POINT(2 1)", 0.3)
pcomp3 <- create_component("MULTIPOINT(5 1, 0 0)", 1)
ppoint <- create_pgeometry(list(pcomp1, pcomp2, pcomp3), "PLATEAUPOINT")

# Converting the pgeometry object into a tibble object
ppoint_tibble <- as_tibble(ppoint)
ppoint_tibble

# Converting it into data.frame
ppoint_df <- as.data.frame(ppoint)
ppoint_df
}
