% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verbose.R
\name{verbose}
\alias{verbose}
\title{Verbose}
\usage{
verbose(...)
}
\arguments{
\item{...}{A message to display.  When \code{...} is \code{NULL} (and only \code{NULL}), no
message will display.}
}
\value{
None, called for its side-effects.  When conditions are met, will
signal a \code{verboseMessage} condition.
}
\description{
Simple verbose condition handling
}
\details{
\code{\link[=verbose]{verbose()}} can be safely placed in scripts to signal additional
message conditions.  \code{\link[=verbose]{verbose()}} can be controlled with \code{options(verbose)}
(the default) and an override, \code{options(fuj.verbose)}.  The latter can be
set to a function whose result will be used for conditional evaluation.
}
\examples{
op <- options(verbose = FALSE)
verbose("will not show")

options(verbose = TRUE)
verbose("message printed")
verbose("multiple lines ", "will be ", "combined")
options(op)

op <- options(fuj.verbose = function() TRUE)
verbose("function will evaluate")
verbose(NULL) # nothing
verbose(NULL, "something")
verbose(if (FALSE) {
"`if` returns `NULL` when not `TRUE`, which makes for additional control"
})
options(op)
}
