% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/7_plottingFunctionsStandard.R
\name{plot,Xfgpm-method}
\alias{plot,Xfgpm-method}
\title{Plot method for the class \code{"Xfgpm"}}
\usage{
\S4method{plot}{Xfgpm}(
  x,
  y = NULL,
  which = c("diag", "evol"),
  calib = TRUE,
  fitp = TRUE,
  horiz = FALSE,
  ...
)
}
\arguments{
\item{x}{The \code{Xfgpm} object to plot.}

\item{y}{Not used.}

\item{which}{Character giving the type of plot wanted. Can take the value
\code{"diag"} or \code{"evol"}. See \bold{Examples}.}

\item{calib}{Logical. If \code{TRUE} the calibration plot of the
selected model will be included in the display in its
"diagnostic" part if \code{which} is set to \code{"diag"}.}

\item{fitp}{Logical. If \code{TRUE} a scatter plot of the quality
of all explored models will be included in the display in its
"diagnostic" part if \code{which} is set to \code{"diag"}.}

\item{horiz}{Logical. Used only when \code{which} is \code{"diag"}
and when both \code{calib} and \code{fitp} are \code{TRUE}. If
\code{horiz} is \code{TRUE} the two subplots are displayed
horizontally (on a same row) rather than vertically which is
the default.}

\item{...}{Other graphical parameters such as \code{main} of
\code{xlab}. When \code{which} is \code{"diag"} and both
\code{calib} and \code{fitp} are \code{TRUE}, the graphical parameters
should be enclosed into a list and passed with the formal name
\code{calib.gpars} or \code{fitp.gpars}.}
}
\description{
Plot an object with class \code{"Xfgpm"} representing
    a collection of functional GP models corresponding to
    different structural parameters.

Two types of graphics can be shown depending on the choice of
\code{which}. The choice \code{which = "diag"} is used to display
diagnostics of the quality of the optimized model. Two types of
diagnostic plots are shown as sub-plots by default, but each can be
discarded if wanted. The choice \code{which = "evol"} is used to
assess the quality of the fitted \code{fgpm} models on the basis of
Leave-One-Out cross-validation.

The choice \code{which = "diag"} (default) provides two plots for
assessing the quality of the output delivered by the model selection
algorithm in the \link[funGp]{fgpm_factory} function. The first
one is a calibration plot similar to the one offered for
\linkS4class{fgpm} objects by \link[funGp]{plot,fgpm-method}.
This plot allows to validate the absolute quality of the selected
model. The second one displays the performance statistic of all
the models successfully evaluated by the model selection
algorithm. This provides a notion of the relative quality of the
selected model with respect to the other models that can be made
using the same data.

The choice \code{which = "evol"} displays the evolution of the
quality of the configurations evaluated along the iterations, by
the model selection algorithm in the \code{fgpm_factory} function. For
each iteration, the performance statistic of all the evaluated
models is printed, along with the corresponding median of the
group. The plot also includes the global maximum, which
corresponds to the best performance statistic obtained up to the
current iteration. In this plot, it is typical to have some points
falling relatively far from the maximum, even after multiple
iterations. This happens mainly because we have multiple
categorical features, whose alteration might change the
performance statistic in a nonsmooth way. On the other hand, the
points that fall below zero usually correspond to models whose
hyperparameters were hard to optimize. This occurs sporadically
during the log-likelihood optimization for Gaussian processes, due
to the non-linearity of the objective function.  As long as the
maximum keeps improving and the median remains close to it, none
of the two aforementioned phenomena is matter for worries.  Both
of them respond to the mechanism of exploration implemented in the
algorithm, which makes it able to progressively move towards
better model configurations.
}
\examples{
# generating input and output data
set.seed(100)
n.tr <- 2^5
x1 <- x2 <- x3 <- x4 <- x5 <- seq(0, 1, length = n.tr^(1/5))
sIn <- expand.grid(x1 = x1, x2 = x2, x3 = x3, x4 = x4, x5 = x5)
fIn <- list(f1 = matrix(runif(n.tr * 10), ncol = 10),
            f2 = matrix(runif(n.tr * 22), ncol = 22))
sOut <- fgp_BB7(sIn, fIn, n.tr)
\dontrun{
# optimizing the model structure with 'fgpm_factory' (~10 seconds)
xm <- fgpm_factory(sIn = sIn, fIn = fIn, sOut = sOut)
# assessing the quality of the model - absolute and w.r.t. the other
# explored models
plot(xm, which = "evol")
# diagnostics (two subplots)
plot(xm, which = "diag")
plot(xm, which = "diag", horiz = TRUE)
# diagnostics (one plot)
plot(xm, which = "diag", fitp = FALSE)
plot(xm, which = "diag", calib = FALSE)
# customizing some graphical parameters
plot(xm, calib.gpars = list(xlim = c(800,1000), ylim = c(600,1200)),
     fitp.gpars = list(main = "Relative quality", legends = FALSE))

}
}
\seealso{
\strong{*} \link[funGp]{fgpm_factory} for structural
    optimization of funGp models.
}
