% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics.R
\name{stat_cff}
\alias{stat_cff}
\title{Cuevas-Febrero-Fraiman statistic}
\usage{
stat_cff(MatX, MatY)
}
\arguments{
\item{MatX}{numeric matrix of dimension \verb{n_point x n} containing \code{n}
trajectories (in columns) of size \code{n_point} (in rows).}

\item{MatY}{numeric matrix of dimension \verb{n_point x m} containing \code{m}
trajectories (in columns) of size \code{n_point} (in rows).}
}
\value{
numeric value corresponding to the WMW statistic value
}
\description{
The Cuevas-Febrero-Fraiman statistics defined in
Cuevas et al (2004) (and noted CFF in Smida et al 2022)
is computed to compare two sets of functional trajectories.
}
\examples{
simu_data <- simul_data(
    n_point = 100, n_obs1 = 50, n_obs2 = 75, c_val = 10, 
    delta_shape = "constant", distrib = "normal"
)

MatX <- simu_data$mat_sample1
MatY <- simu_data$mat_sample2

stat_cff(MatX, MatY)
}
\references{
Cuevas, A, Febrero, M, and Fraiman, R (2004)
An anova test for functional data. Computational Statistics & Data
Analysis, 47(1): 111–122. \doi{10.1016/j.csda.2003.10.021}

Zaineb Smida, Lionel Cucala, Ali Gannoun & Ghislain Durif (2022)
A median test for functional data, Journal of Nonparametric Statistics,
34:2, 520-553,
\doi{10.1080/10485252.2022.2064997},
\href{https://hal.science/hal-03658578}{hal-03658578}
}
\seealso{
\code{\link[=comp_stat]{comp_stat()}}, \code{\link[=permut_pval]{permut_pval()}}
}
