

#' Improper correlation matrix reported by Bentler and Yuan
#' 
#' Example improper R matrix reported by Bentler and Yuan (2011)
#' 
#' @name BadRBY
#' @format A 12 by 12 non-positive definite correlation matrix.
#' @source Bentler, P. M. & Yuan, K. H. (2011). Positive definiteness via
#' off-diagonal scaling of a symmetric indefinite matrix. Psychometrika, 76(1),
#' 119--123.
#' @keywords statistics
#' @examples
#' 
#' data(BadRBY)
#' 
NULL





#' Improper R matrix reported by Joseph and Newman
#' 
#' Example NPD improper correlation matrix reported by Joseph and Newman
#' 
#' @name BadRJN
#' @format A 14 by 14 non-positive definite correlation matrix.
#' @source Joseph, D. L. & Newman, D. A. (2010). Emotional intelligence: an
#' integrative meta-analysis and cascading model. Journal of Applied
#' Psychology, 95(1), 54--78.
#' @keywords statistics
#' @examples
#' 
#' data(BadRJN)
#' 
NULL





#' Improper R matrix reported by Knol and ten Berge
#' 
#' Example improper R matrix reported by Knol and ten Berge
#' 
#' @name BadRKtB
#' @format A 6 by 6 non-positive definite correlation matrix.
#' @source Knol, D. L. and Ten Berge, J. M. F.  (1989).  Least-squares
#' approximation of an improper correlation matrix by a proper one.
#' Psychometrika, 54(1), 53-61.
#' @keywords statistics
#' @examples
#' 
#' data(BadRKtB)
#' 
NULL





#' Improper R matrix reported by Lurie and Goldberg
#' 
#' Example improper R matrix reported by Lurie and Goldberg
#' 
#' @name BadRLG
#' @format A 3 by 3 non-positive definite correlation matrix.
#' @source Lurie, P. M. & Goldberg, M. S. (1998). An approximate method for
#' sampling correlated random variables from partially-specified distributions.
#' Management Science, 44(2), 203--218.
#' @keywords statistics
#' @examples
#' 
#' data(BadRLG)
#' 
NULL





#' Improper R matrix reported by Rousseeuw and Molenberghs
#' 
#' Example improper R matrix reported by Rousseeuw and Molenberghs
#' 
#' @name BadRRM
#' @format A 3 by 3 non-positive definite correlation matrix.
#' @source Rousseeuw, P. J. & Molenberghs, G. (1993). Transformation of non
#' positive semidefinite correlation matrices. Communications in
#' Statistics--Theory and Methods, 22(4), 965--984.
#' @keywords statistics
#' @examples
#' 
#' data(BadRRM)
#' 
NULL





#' 9 Variables from the Holzinger and Swineford (1939) Dataset
#' 
#' Mental abilities data on seventh- and eighth-grade children from the classic
#' Holzinger and Swineford (1939) dataset.
#' 
#' 
#' @name HS9Var
#' @docType data
#' @format A data frame with 301 observations on the following 15 variables.
#' \describe{ \item{id}{subject identifier} \item{sex}{gender}
#' \item{ageyr}{age, year part} \item{agemo}{age, month part}
#' \item{school}{school name (Pasteur or Grant-White)} \item{grade}{grade}
#' \item{x1}{Visual perception} \item{x2}{Cubes} \item{x3}{Lozenges}
#' \item{x4}{Paragraph comprehension} \item{x5}{Sentence completion}
#' \item{x6}{Word meaning} \item{x7}{Speeded addition} \item{x8}{Speeded
#' counting of dots} \item{x9}{Speeded discrimination straight and curved
#' capitals} }
#' @references Holzinger, K., and Swineford, F. (1939). A study in factor
#' analysis: The stability of a bifactor solution. Supplementary Educational
#' Monograph, no. 48. Chicago: University of Chicago Press.
#' 
#' Joreskog, K. G. (1969). A general approach to confirmatory maximum
#' likelihood factor analysis. \emph{Psychometrika, 34}, 183-202.
#' @source These data were retrieved from the lavaan package. The complete data
#' for all 26 tests are available in the MBESS package.
#' @keywords datasets
#' @examples
#' 
#' data(HS9Var)
#' head(HS9Var)
#' 
NULL



