% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ledermann.R
\name{Ledermann}
\alias{Ledermann}
\title{Ledermann's inequality for factor solution identification}
\usage{
Ledermann(numFactors = NULL, numVariables = NULL)
}
\arguments{
\item{numFactors}{(Numeric) Determine the number of variables needed
to uniquely estimate the [user-specifed] number of factors. Defaults 
to \code{numFactors = NULL}.}

\item{numVariables}{(Numeric) Determine the number of factors that can be
uniquely estimated from the [user-specifed] number of variables Defaults 
to \code{numVariables = NULL}.}
}
\value{
\itemize{
   \item \bold{numFactors} (Numeric) Given the inputs, the number of factors 
   to be estimated from the \code{numVariables} number of factor indicators. 
   \item \bold{numVariables} (Numeric) Given the inputs, the number of 
   variables needed to estimate \code{numFactorso}. 
}
}
\description{
Ledermann's (1937) inequality to determine either (a) how many factor 
indicators are needed to uniquely estimate a user-specified number 
of factors or (b) how many factors can be uniquely estimated from 
a user-specified number of factor indicators. See the \strong{Details} 
section for more information
}
\details{
The user will specified either (a) \code{numFactors} or (b) 
\code{numVariables}. When one value is specified, the obtained estimate 
for the other may be a non-whole number. If estimating the number of 
required variables, the obtained estimate is rounded up 
(using \code{\link[base]{ceiling}}). If estimating the number of factors,
the obtained estimate is rounded down (using \code{\link[base]{floor}}). For example,
if \code{numFactors = 2}, roughly 4.56 variables are required for an identified
solution. However, the function returns an estimate of 5.

For the relevant equations, see Thurstone (1947, p. 293) Equations 10 
and 11.
}
\examples{
## To estimate 3 factors, how many variables are needed?
Ledermann(numFactors   = 3,
          numVariables = NULL) 
          
## Provided 10 variables are collected, how many factors 
  ## can be estimated?
Ledermann(numFactors   = NULL,
          numVariables = 10)

}
\references{
Ledermann, W. (1937). On the rank of the reduced correlational 
matrix in multiple-factor analysis. \emph{Psychometrika, 2}(2), 85-93.

Thurstone, L. L. (1947). Multiple-factor analysis; a development and expansion of The Vectors of Mind.
}
\seealso{
Other Factor Analysis Routines: 
\code{\link{BiFAD}()},
\code{\link{Box26}},
\code{\link{GenerateBoxData}()},
\code{\link{SLi}()},
\code{\link{SchmidLeiman}()},
\code{\link{faAlign}()},
\code{\link{faEKC}()},
\code{\link{faMB}()},
\code{\link{faMain}()},
\code{\link{faScores}()},
\code{\link{faSort}()},
\code{\link{faStandardize}()},
\code{\link{faX}()},
\code{\link{fals}()},
\code{\link{fapa}()},
\code{\link{fareg}()},
\code{\link{orderFactors}()},
\code{\link{print.faMain}()},
\code{\link{promaxQ}()},
\code{\link{summary.faMain}()}
}
\author{
Casey Giordano
}
\concept{Factor Analysis Routines}
