% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trainingFunctions.R
\name{createTraining}
\alias{createTraining}
\title{createTraining}
\usage{
createTraining(
  id,
  target_df,
  ind_col,
  target,
  problem_type = "classification",
  verbose = TRUE
)
}
\arguments{
\item{id}{\code{character} \cr
Training's ID.}

\item{target_df}{\code{data.frame} \cr
Observed target values. A data frame with two columns: individual IDs and response variable values.}

\item{ind_col}{\code{character} \cr
Name of column of individuals IDs.}

\item{target}{\code{character} \cr
Name of the target variable.}

\item{problem_type}{\code{character} \cr
Either "classification" or "regression".}

\item{verbose}{\code{boolean} \cr
Warning and processing information (including those of cross-validation) will be displayed if set to TRUE.}
}
\value{
The created \link{Training} object is returned.
}
\description{
Creates a \link{Training} object. A training object is designed to encapsulate training layers
and training meta-layer. Functions \link{createTrainLayer} and \link{createTrainMetaLayer} are available
to add the training layer and the training meta-layer to a training object.
}
\seealso{
\link{createTrainLayer}, \link{createTrainMetaLayer} and \link{fusemlr}.
}
