% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MGM_plots.r
\name{FMGM_plot}
\alias{FMGM_plot}
\title{A plot function for a list of MGMs.
The output is usually from FMGM main function.}
\usage{
FMGM_plot(
  MGM_list,
  sortby = "diff",
  highlight = c(),
  tol_polish = 1e-12,
  tol_plot = 0.01,
  sideColor = FALSE,
  distfun = dist,
  hclustfun = hclust,
  reorderfun = function(d, w) reorder(d, w),
  margins = c(2.5, 2.5),
  cexRow = 0.1 + 0.5/log10(n),
  cexCol = cexRow,
  main = NULL,
  xlab = NULL,
  ylab = NULL,
  verbose = getOption("verbose")
)
}
\arguments{
\item{MGM_list}{A list of graphs from 2 groups. Usually a result of FMGM main function.}

\item{sortby}{Determines the standard of sorting & dendrograms. Either 1, 2, or "diff" (default).}

\item{highlight}{A vector of variable names or indices to highlight}

\item{tol_polish}{A threshold for the network edge presence}

\item{tol_plot}{Only network edges above this value will be displayed on the heatmap}

\item{sideColor}{A named vector determining a sidebar colors. Set NULL to make the colors based on the variable types (discrete/continuous). Default: FALSE (no sidebars)}

\item{distfun}{A function for the distances between rows/columns}

\item{hclustfun}{A function for hierarchical clustering}

\item{reorderfun}{A function of dendrogram and weights for reordering}

\item{margins}{A numeric vector of 2 numbers for row & column name margins}

\item{cexRow}{A visual parameter cex for row axis labeling}

\item{cexCol}{A visual parameter cex for column axis labeling, default to be same as cexRow}

\item{main}{Main title, default to none}

\item{xlab}{X-axis title, default to none}

\item{ylab}{Y-axis title, default to none}

\item{verbose}{Logical. Should plotting information be printed?}
}
\value{
None
}
\description{
This function is written based on R base function 'heatmap'.
}
\examples{
\donttest{
data(data_all) ;  # Example 500-by-100 simulation data
data(ind_disc) ;

group <- rep(c(1,2), each=250) ;
names(group) <- seq(500) ;

if (Sys.info()['sysname'] == 'Windows') {
  cores=1
} else {
  cores=parallel::detectCores() ;
}

res_FMGM <- FMGM_mc(data_all, ind_disc, group, 
                    lambda_intra=c(0.2,0.15,0.1), lambda_inter=c(0.2,0.15,0.1), 
                    cores=cores, verbose=TRUE)
                    
FMGM_plot(res_FMGM)
}
}
