% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Future-class.R
\name{Future-class}
\alias{Future-class}
\alias{Future}
\title{A future represents a value that will be available at some point in the future}
\usage{
Future(expr = NULL, envir = parent.frame(), substitute = FALSE,
  stdout = TRUE, globals = NULL, packages = NULL, seed = NULL,
  lazy = FALSE, local = TRUE, gc = FALSE, earlySignal = FALSE,
  label = NULL, ...)
}
\arguments{
\item{expr}{An \R \link[base]{expression}.}

\item{envir}{The \link{environment} from where global objects should be
identified.}

\item{substitute}{If TRUE, argument \code{expr} is
\code{\link[base]{substitute}()}:ed, otherwise not.}

\item{stdout}{If TRUE (default), then the standard output is captured,
and re-outputted when \code{value()} is called.
If FALSE, any output is silenced (by sinking it to the null device as
it is outputted).
If NA (not recommended), output is \emph{not} intercepted.}

\item{globals}{(optional) a logical, a character vector, or a named list
to control how globals are handled.
For details, see section 'Globals used by future expressions'
in the help for \code{\link{future}()}.}

\item{packages}{(optional) a character vector specifying packages
to be attached in the \R environment evaluating the future.}

\item{seed}{(optional) A L'Ecuyer-CMRG RNG seed.}

\item{lazy}{If \code{FALSE} (default), the future is resolved
eagerly (starting immediately), otherwise not.}

\item{local}{If TRUE, the expression is evaluated such that
all assignments are done to local temporary environment, otherwise
the assignments are done to the global environment of the \R process
evaluating the future.}

\item{gc}{If TRUE, the garbage collector run (in the process that
evaluated the future) after the value of the future is collected.
\emph{Some types of futures ignore this argument.}}

\item{earlySignal}{Specified whether conditions should be signaled as soon
as possible or not.}

\item{label}{An optional character string label attached to the future.}

\item{\dots}{Additional named elements of the future.}
}
\value{
An object of class \code{Future}.
}
\description{
A \emph{future} is an abstraction for a \emph{value} that may
available at some point in the future.  A future can either be
\code{unresolved} or \code{resolved}, a state which can be checked
with \code{\link{resolved}()}.  As long as it is \emph{unresolved}, the
value is not available.  As soon as it is \emph{resolved}, the value
is available via \code{\link[future]{value}()}.
}
\details{
A Future object is itself an \link{environment}.
}
\seealso{
One function that creates a Future is \code{\link{future}()}.
It returns a Future that evaluates an \R expression in the future.
An alternative approach is to use the \code{\link{\%<-\%}} infix
assignment operator, which creates a future from the
right-hand-side (RHS) \R expression and assigns its future value
to a variable as a \emph{\link[base]{promise}}.
}
\keyword{internal}
