% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FutureResult-class.R
\name{FutureResult}
\alias{FutureResult}
\alias{as.character.FutureResult}
\alias{print.FutureResult}
\title{Results from resolving a future}
\usage{
FutureResult(
  value = NULL,
  stdout = NULL,
  conditions = NULL,
  ...,
  started = .POSIXct(NA_real_),
  finished = Sys.time(),
  version = "1.8"
)

\method{as.character}{FutureResult}(x, ...)

\method{print}{FutureResult}(x, ...)
}
\arguments{
\item{value}{The value of the future expression.
If the expression was not fully resolved (e.g. an error) occurred,
the the value is \code{NULL}.}

\item{conditions}{A list of zero or more list elements each containing
a captured \link[base:condition]{condition} and possibly more meta data such as the
call stack and a timestamp.}

\item{\dots}{(optional) Additional named results to be returned.}

\item{started, finished}{\link[base:POSIXct]{POSIXct} timestamps when the evaluation of
the future expression was started and finished.}

\item{version}{The version format of the results.}
}
\value{
An object of class FutureResult.
}
\description{
Results from resolving a future
}
\details{
This function is only part of the \emph{backend} Future API.
This function is \emph{not} part of the frontend Future API.
}
\section{Note to developers}{

The FutureResult structure is \emph{under development} and may change at anytime,
e.g. elements may be renamed or removed.  Because of this, please avoid
accessing the elements directly in code.  Feel free to reach out if you need
to do so in your code.
}

\keyword{internal}
