% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_RF.R
\name{select_RF}
\alias{select_RF}
\title{Carries out the selection step of fuzzyforest algorithm.}
\usage{
select_RF(X, y, drop_fraction, number_selected, mtry_factor, ntree_factor,
  min_ntree, num_processors, nodesize)
}
\arguments{
\item{X}{A data.frame.
Each column corresponds to a feature vectors.
Could include additional covariates not a part of
the original modules.}

\item{y}{Response vector.}

\item{drop_fraction}{A number between 0 and 1.  Percentage of features
dropped at each iteration.}

\item{number_selected}{Number of features selected by fuzzyforest.}

\item{mtry_factor}{In the case of regression, \code{mtry} is set to
\code{ceiling}(\eqn{\sqrt(p)}*\code{mtry_factor}).
In the case of classification, \code{mtry} is set to
\code{ceiling}((p/3)*\code{mtry_factor}).  If either
of these numbers is greater than p, \code{mtry} is
set to p.}

\item{ntree_factor}{A number greater than 1.  \code{ntree} for each
random is \code{ntree_factor} times the number
of features.  For each random forest, \code{ntree}
is set to \code{max}(\code{min_ntree},
\code{ntree_factor}*\code{p}).}

\item{min_ntree}{Minimum number of trees grown in each random forest.}

\item{num_processors}{Number of processors used to fit random forests.}

\item{nodesize}{Minimum nodesize}
}
\value{
A data.frame with the top ranked features.
}
\description{
Carries out the selection step of fuzzyforest algorithm.  Returns
data.frame with variable importances and top rated features.
}
\note{
This work was partially funded by NSF IIS 1251151 and AMFAR 8721SC.
}

