% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fuzzy_forest_obj.R
\name{predict.fuzzy_forest}
\alias{predict.fuzzy_forest}
\title{Predict method for fuzzy_forest object.
Obtains predictions from fuzzy forest algorithm.}
\usage{
\method{predict}{fuzzy_forest}(object, new_data, ...)
}
\arguments{
\item{object}{A fuzzy_forest object.}

\item{new_data}{A matrix or data.frame containing new_data.
Pay close attention to ensure feature names
match between training set and test set
data.frame.}

\item{...}{Additional arguments not in use.}
}
\value{
A vector of predictions
}
\description{
Predict method for fuzzy_forest object.
Obtains predictions from fuzzy forest algorithm.
}
\note{
This work was partially funded by NSF IIS 1251151 and AMFAR 8721SC.
}
\examples{
library(mvtnorm)
gen_mod <- function(n, p, corr) {
  sigma <- matrix(corr, nrow=p, ncol=p)
  diag(sigma) <- 1
  X <- rmvnorm(n, sigma=sigma)
  return(X)
}

gen_X <- function(n, mod_sizes, corr){
  m <- length(mod_sizes)
  X_list <- vector("list", length = m)
  for(i in 1:m){
    X_list[[i]] <- gen_mod(n, mod_sizes[i], corr[i])
  }
  X <- do.call("cbind", X_list)
  return(X)
}

err_sd <- .5
n <- 500
mod_sizes <- rep(25, 4)
corr <- rep(.8, 4)
X <- gen_X(n, mod_sizes, corr)
beta <- rep(0, 100)
beta[c(1:4, 76:79)] <- 5
y <- X\%*\%beta + rnorm(n, sd=err_sd)
X <- as.data.frame(X)

Xtest <- gen_X(n, mod_sizes, corr)
ytest <- Xtest\%*\%beta + rnorm(n, sd=err_sd)
Xtest <- as.data.frame(Xtest)

cdist <- as.dist(1 - cor(X))
hclust_fit <- hclust(cdist, method="ward.D")
groups <- cutree(hclust_fit, k=4)

screen_c <- screen_control(keep_fraction = .25,
                           ntree_factor = 1,
                           min_ntree = 250)
select_c <- select_control(number_selected = 10,
                           ntree_factor = 1,
                           min_ntree = 250)
\donttest{
ff_fit <- ff(X, y, module_membership = groups,
             screen_params = screen_c,
             select_params = select_c,
             final_ntree = 250)
#extract variable importance rankings
vims <- ff_fit$feature_list

#plot results
modplot(ff_fit)

#obtain predicted values for a new test set
preds <- predict(ff_fit, new_data=Xtest)

#estimate test set error
test_err <- sqrt(sum((ytest - preds)^2)/n)
}
}
\seealso{
\code{\link[fuzzyforest]{ff}},
         \code{\link[fuzzyforest]{wff}},
         \code{\link[fuzzyforest]{ff.formula}},
         \code{\link[fuzzyforest]{wff.formula}}
}
