% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flar.R
\name{flar}
\alias{flar}
\title{Fuzzy Linear Regression using the Fuzzy Least Absolute Residual Method}
\usage{
flar(x, y)
}
\arguments{
\item{x}{matrix with the second to last columns representing independent variable
observations. The first column is related to the intercept, so it consists of ones.
Missing values not allowed.}

\item{y}{matrix of dependent variable observations. The first column contains the
central tendency, the second column the left spread and the third column the right
spread of non-symmetric triangular fuzzy numbers. Missing values not allowed.}
}
\value{
Returns a \code{fuzzylm} object that includes the model coefficients, limits
for data predictions from the model and the input data.
}
\description{
The function calculates fuzzy regression coeficients using the fuzzy least absolute
residual (FLAR) method proposed by Zeng et al. (2017)
for non-symmetric triangular fuzzy numbers.
}
\details{
The FLAR method expects real value input for the explanatory variables, and
non-symmetric triangular fuzzy numbers for the response variable. The prediction
returns non-symmetric triangular fuzzy numbers.
}
\note{
Preferred use is through the \code{\link{fuzzylm}} wrapper function with argument
\code{method = "flar"}.
}
\examples{
   data(fuzzydat)
   fuzzylm(y ~ x, fuzzydat$dia, "flar", , , "yl", "yl")
}
\references{
Zeng, W., Feng, Q. and Li, J. (2017) Fuzzy least absolute linear regression.
\emph{Applied Soft Computing} 52: 1009-1019.
}
\seealso{
\code{\link{fuzzylm}}
}
\keyword{fuzzy}
