/*
 * Decompiled with CFR 0.152.
 */
package org.mutoss.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileWriter;
import java.text.DecimalFormat;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.af.commons.Localizer;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.logging.LoggingSystem;
import org.af.commons.logging.widgets.DetailsDialog;
import org.mutoss.gui.AboutDialog;
import org.mutoss.gui.RControl;
import org.mutoss.gui.graph.ControlMGraph;
import org.mutoss.gui.graph.NetzListe;

public class MenuBarMGraph
extends JMenuBar
implements ActionListener {
    ControlMGraph control;
    protected Localizer localizer = Localizer.getInstance();
    DecimalFormat format = new DecimalFormat("#.###");
    public String LATEX_BEGIN_DOCUMENT = "\\documentclass[11pt]{article}\n\\usepackage{tikz}\n\\usetikzlibrary{snakes,arrows,shapes}\n\\begin{document}\n";
    public String LATEX_END_DOCUMENT = "\\end{document}";

    public MenuBarMGraph(ControlMGraph control) {
        this.control = control;
        JMenu menu = new JMenu("File");
        menu.add(this.makeMenuItem("New Graph", "new graph"));
        menu.add(this.makeMenuItem("Save Graph as Image", "save graph image"));
        menu.add(this.makeMenuItem("Save Graph as LaTeX File", "save graph latex"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Quit", "exit"));
        this.add(menu);
        menu = new JMenu("Example graphs");
        menu.add(this.makeMenuItem("Bonferroni-Holm Test (2 Null Hypotheses)", "bht2"));
        menu.add(this.makeMenuItem("Bonferroni-Holm Test (3 Null Hypotheses)", "bht3"));
        menu.add(this.makeMenuItem("Bonferroni-Holm Test (4 Null Hypotheses)", "bht4"));
        menu.add(this.makeMenuItem("Bonferroni-Holm Test (5 Null Hypotheses)", "bht5"));
        menu.addSeparator();
        menu.add(this.makeMenuItem("Parallel Gatekeeping with 4 Hypotheses", "pg"));
        menu.add(this.makeMenuItem("Improved Parallel Gatekeeping with 4 Hypotheses", "pgi"));
        menu.add(this.makeMenuItem("Example graph from Bretz et al.", "bretzEtAl"));
        this.add(menu);
        this.addExtrasMenu();
    }

    private void loadGraph(String string) {
        NetzListe nl = this.control.getNL();
        this.newGraph();
        RControl.getR().eval(NetzListe.initialGraph + " <- " + string);
        nl.loadGraph();
        this.control.getMainFrame().validate();
    }

    public void newGraph() {
        this.control.getGraphView().stopTesting();
        this.control.getNL().reset();
    }

    public void showAbout() {
        new AboutDialog(this.control.getMainFrame());
    }

    public void showLog() {
        new DetailsDialog(LoggingSystem.getInstance().makeDetailsPanel());
    }

    public void reportError() {
        ErrorHandler.getInstance().makeErrDialog(this.localizer.getString("SGTK_MENU_EXTRAS_REPORT_ERROR"));
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals("new graph")) {
            this.newGraph();
        } else if (!e.getActionCommand().equals("save graph") && !e.getActionCommand().equals("save pdf")) {
            if (e.getActionCommand().equals("save graph image")) {
                this.saveGraphImage();
            } else if (e.getActionCommand().equals("save graph latex")) {
                this.exportLaTeXGraph();
            } else if (!e.getActionCommand().equals("save latex report") && !e.getActionCommand().equals("load graph")) {
                if (e.getActionCommand().equals("bht2")) {
                    this.loadGraph("createBonferroniHolmGraph(2)");
                } else if (e.getActionCommand().equals("bht3")) {
                    this.loadGraph("createBonferroniHolmGraph(3)");
                } else if (e.getActionCommand().equals("bht4")) {
                    this.loadGraph("createBonferroniHolmGraph(4)");
                } else if (e.getActionCommand().equals("bht5")) {
                    this.loadGraph("createBonferroniHolmGraph(5)");
                } else if (e.getActionCommand().equals("pg")) {
                    this.loadGraph("createGraphForParallelGatekeeping()");
                } else if (e.getActionCommand().equals("pgi")) {
                    this.loadGraph("createGraphForImprovedParallelGatekeeping()");
                } else if (e.getActionCommand().equals("bretzEtAl")) {
                    this.loadGraph("createGraphFromBretzEtAl()");
                } else if (e.getActionCommand().equals("showLog")) {
                    this.showLog();
                } else if (e.getActionCommand().equals("reportError")) {
                    this.reportError();
                } else if (e.getActionCommand().equals("exit")) {
                    this.control.getMainFrame().dispose();
                }
            }
        }
    }

    public void writeLaTeX(String s) {
        File f;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showSaveDialog(this);
        if (returnVal == 0) {
            f = fc.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".tex")) {
                f = new File(f.getAbsolutePath() + ".tex");
            }
        } else {
            return;
        }
        System.out.println("Export to: " + f.getAbsolutePath() + ".");
        try {
            FileWriter out = new FileWriter(f);
            out.write(this.LATEX_BEGIN_DOCUMENT);
            out.write(s);
            out.write(this.LATEX_END_DOCUMENT);
            out.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(null, "Saving LaTeX code to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
        }
    }

    public void exportLaTeXGraph() {
        NetzListe nl = this.control.getNL();
        this.writeLaTeX(nl.getLaTeX());
    }

    private void saveGraphImage() {
        BufferedImage img = this.control.getNL().getImage();
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog(this);
        if (returnVal == 0) {
            File f = fc.getSelectedFile();
            if (!f.getName().toLowerCase().endsWith(".png")) {
                f = new File(f.getAbsolutePath() + ".png");
            }
            try {
                ImageIO.write((RenderedImage)img, "png", f);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Saving image to '" + f.getAbsolutePath() + "' failed: " + ex.getMessage(), "Saving failed.", 0);
            }
        }
    }

    protected JMenuItem makeMenuItem(String text, String action) {
        return this.makeMenuItem(text, action, true);
    }

    protected JMenuItem makeMenuItem(String text, String action, boolean enabled) {
        JMenuItem item = new JMenuItem(text);
        item.setActionCommand(action);
        item.setEnabled(enabled);
        item.addActionListener(this);
        return item;
    }

    public void addExtrasMenu() {
        this.add(this.makeExtrasMenu());
    }

    public JMenu makeExtrasMenu() {
        JMenu menu = new JMenu(this.localizer.getString("SGTK_MENU_EXTRAS"));
        menu.add(this.makeMenuItem(this.localizer.getString("SGTK_MENU_EXTRAS_LOG"), "showLog"));
        menu.add(this.makeMenuItem(this.localizer.getString("SGTK_MENU_EXTRAS_REPORT_ERROR"), "reportError"));
        return menu;
    }
}

