/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.pdf;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.af.commons.errorhandling.ErrorHandler;
import org.af.commons.tools.OSTools;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PDFViewerStarter {
    private static final Log logger = LogFactory.getLog(PDFViewerStarter.class);
    private final File pdfviewer;
    private final String viewerOptions;

    public PDFViewerStarter(String viewerPath, String viewerOptions, File pdf) {
        this(new File(viewerPath), viewerOptions);
        this.start(pdf);
    }

    public PDFViewerStarter(String viewerPath, String viewerOptions) {
        this(new File(viewerPath), viewerOptions);
    }

    public PDFViewerStarter(File pdfviewer, String viewerOptions) {
        this.pdfviewer = pdfviewer;
        this.viewerOptions = viewerOptions;
    }

    public void start(File pdf) {
        String msg;
        Exception exc = null;
        try {
            if (this.pdfviewer != null) {
                if (!this.pdfviewer.exists() || !pdf.isFile()) {
                    msg = "The PDF viewer you supplied in the options\ndoes not point to a valid file!\nPlease try to correct your options.";
                    if (OSTools.isWindows()) {
                        msg = msg + "\n\nTrying to open with associated\n application for file type \"pdf\" now...";
                    }
                    JOptionPane.showMessageDialog(null, msg);
                    this.startByOS(pdf);
                } else {
                    this.startByConfiguredViewer(pdf);
                }
            } else {
                this.startByOS(pdf);
            }
        }
        catch (IOException e) {
            exc = e;
        }
        catch (InterruptedException e) {
            exc = e;
        }
        if (exc != null) {
            msg = "There was an error opening the pdf file!\nPlease check the pdf viewer options.\n\nError was: " + exc.getMessage();
            ErrorHandler.getInstance().makeErrDialog(msg, (Object)exc);
        }
    }

    private void startByConfiguredViewer(File pdf) throws IOException {
        Vector<String> command = new Vector<String>();
        command.add(this.pdfviewer.getAbsolutePath());
        if (!this.viewerOptions.equals("")) {
            StringTokenizer st = new StringTokenizer(this.viewerOptions);
            while (st.hasMoreTokens()) {
                command.add(st.nextToken());
            }
        }
        command.add(pdf.getAbsolutePath());
        logger.info((Object)("Starting PDF viewer: " + command));
        ProcessBuilder pb = new ProcessBuilder(command);
        pb.start();
    }

    private void startByOS(File pdf) throws IOException, InterruptedException {
        if (OSTools.isWindows()) {
            this.startByRunDLL(pdf);
        }
    }

    private void startByRunDLL(File pdf) throws IOException, InterruptedException {
        Process p = null;
        p = Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler " + pdf.getAbsolutePath());
        p.waitFor();
    }

    public void start(String pdfPath) throws IOException, InterruptedException {
        this.start(new File(pdfPath));
    }
}

