/*
 * Decompiled with CFR 0.152.
 */
package org.af.gMCP.gui.power;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.af.commons.widgets.buttons.OkCancelButtonPane;
import org.af.gMCP.config.Configuration;
import org.af.gMCP.gui.CreateGraphGUI;
import org.af.gMCP.gui.RControl;
import org.af.gMCP.gui.dialogs.PowerOptionsPanel;
import org.af.gMCP.gui.dialogs.TextFileViewer;
import org.af.gMCP.gui.power.CVPanel;
import org.af.gMCP.gui.power.GroupPanel;
import org.af.gMCP.gui.power.PDialog;
import org.af.gMCP.gui.power.ScenarioPanel;
import org.af.gMCP.gui.power.UserDefinedPanel;
import org.jdesktop.swingworker.SwingWorker;

public class SampleSizeDialog
extends PDialog
implements ActionListener {
    GroupPanel gPanel;
    String rCommand = "";

    public SampleSizeDialog(CreateGraphGUI parent) {
        super(parent, "Power Simulation - specify probability distribution of test statistics", true);
        this.setLocationRelativeTo(parent);
        this.parent = parent;
        this.nodes = parent.getGraphView().getNL().getNodes();
        parent.getPView().getParameters();
        GridBagConstraints c = SampleSizeDialog.getDefaultGridBagConstraints();
        this.getContentPane().setLayout(new GridBagLayout());
        this.gPanel = new GroupPanel(this);
        this.tPanel.addTab("Groups", this.gPanel);
        this.pNCP = new ScenarioPanel(this);
        this.tPanel.addTab("Noncentrality Parameter (NCP) Settings", this.pNCP);
        this.cvPanel = new CVPanel(this);
        this.tPanel.addTab("Correlation Matrix", this.cvPanel);
        this.userDefinedFunctions = new UserDefinedPanel(this.nodes);
        this.tPanel.addTab("User defined power function", this.userDefinedFunctions);
        this.tPanel.addTab("Options", new PowerOptionsPanel(parent));
        Set<String> variables = parent.getGraphView().getNL().getAllVariables();
        if (!Configuration.getInstance().getGeneralConfig().useEpsApprox()) {
            variables.remove("\u03b5");
        }
        this.getContentPane().add((Component)this.tPanel, c);
        c.weighty = 0.0;
        ++c.gridy;
        c.weightx = 0.0;
        c.fill = 0;
        c.anchor = 13;
        OkCancelButtonPane bp = new OkCancelButtonPane();
        this.getContentPane().add((Component)bp, c);
        bp.addActionListener((ActionListener)this);
        this.pack();
        this.setLocationRelativeTo(parent);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        double alpha;
        String weights = this.parent.getGraphView().getNL().getGraphName() + "@weights";
        try {
            alpha = this.parent.getPView().getTotalAlpha();
        }
        catch (Exception e1) {
            return;
        }
        String G = this.parent.getGraphView().getNL().getGraphName() + "@m";
        if (e.getActionCommand().equals("OK")) {
            this.rCommand = "gMCP:::calcMultiPower(weights=" + weights + ", alpha=" + alpha + ", G=" + G + this.pNCP.getNCPString() + "," + "corr.sim = " + this.cvPanel.getSigma() + this.cvPanel.getMatrixForParametricTest() + this.userDefinedFunctions.getUserDefined() + ", nSim = " + Configuration.getInstance().getGeneralConfig().getNumberOfSimulations() + ", type = \"" + Configuration.getInstance().getGeneralConfig().getTypeOfRandom() + "\"" + ")";
            this.parent.glassPane.start();
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                protected Void doInBackground() throws Exception {
                    try {
                        String result = RControl.getR().eval(SampleSizeDialog.this.rCommand).asRChar().getData()[0];
                        new TextFileViewer((JFrame)SampleSizeDialog.this.parent, "Power results", result, true);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        JOptionPane.showMessageDialog(SampleSizeDialog.this.parent, "R call produced an error:\n\n" + message + "\nWe will open a window with R code to reproduce this error for investigation.", "Error in R Call", 0);
                        JDialog d = new JDialog(SampleSizeDialog.this.parent, "R Error", true);
                        d.add(new TextFileViewer((JFrame)SampleSizeDialog.this.parent, "R Objects", "The following R code produced the following error:\n\n" + message + SampleSizeDialog.this.rCommand, true));
                        d.pack();
                        d.setSize(800, 600);
                        d.setVisible(true);
                        e.printStackTrace();
                    }
                    finally {
                        SampleSizeDialog.this.parent.glassPane.stop();
                    }
                    return null;
                }
            };
            worker.execute();
        }
        this.dispose();
    }
}

