% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{texToPng}
\alias{texToPng}
\title{Convert LaTeX to a png file}
\usage{
texToPng(
  tex,
  width = NULL,
  height = NULL,
  dpi = 72,
  viewPng = FALSE,
  fontsize = 12,
  calcM = FALSE,
  crop = FALSE
)
}
\arguments{
\item{tex}{TeX string. Remember to escape backslash with \\.}

\item{width}{Width of the png.}

\item{height}{Height of the png (\code{width} are ignored).}

\item{dpi}{Dpi of the png. Not used if \code{width} or \code{height} are specified.}

\item{viewPng}{View the result in the plots window.}

\item{fontsize}{Front size used in the LaTeX document.}

\item{calcM}{Estimate 1 em in pixels in the resulting png.}

\item{crop}{Call pdfcrop.}
}
\value{
The filename of the png or a list if \code{calcM = TRUE}.
}
\description{
Convert LaTeX to a png file
}
\examples{
\dontrun{
tex <- "$\\\\mathbb{R}_{\\\\geqq}$"
texToPng(tex, viewPng = TRUE)
texToPng(tex, fontsize = 20, viewPng = TRUE)
texToPng(tex, height = 50, fontsize = 10, viewPng = TRUE)
texToPng(tex, height = 50, fontsize = 50, viewPng = TRUE)
tex <- "MMM"
texToPng(tex, dpi=72, calcM = TRUE)
texToPng(tex, width = 100, calcM = TRUE)
f <- texToPng(tex, dpi=300)
pngSize(f)
}
}
