% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ndset.R
\name{classifyNDSet}
\alias{classifyNDSet}
\title{Classify a set of nondominated points}
\usage{
classifyNDSet(pts, direction = 1)
}
\arguments{
\item{pts}{A set of non-dominated points. It is assumed that \code{ncol(pts)} equals the number of
objectives ($p$).}

\item{direction}{Ray direction. If i'th entry is positive, consider the i'th column of the \code{pts}
plus a value greater than on equal zero (minimize objective $i$). If negative, consider the
i'th column of the \code{pts} minus a value greater than on equal zero (maximize objective $i$).}
}
\value{
The ND set with classification columns.
}
\description{
The classification is supported (true/false), extreme (true/false), supported non-extreme
(true/false)
}
\note{
It is assumed that \code{pts} are nondominated.
}
\examples{
\donttest{
pts <- matrix(c(0,0,1, 0,1,0, 1,0,0, 0.5,0.2,0.5, 0.25,0.5,0.25), ncol = 3, byrow = TRUE)
ini3D(argsPlot3d = list(xlim = c(min(pts[,1])-2,max(pts[,1])+2),
  ylim = c(min(pts[,2])-2,max(pts[,2])+2),
  zlim = c(min(pts[,3])-2,max(pts[,3])+2)))
plotHull3D(pts, addRays = TRUE, argsPolygon3d = list(alpha = 0.5), useRGLBBox = TRUE)
pts <- classifyNDSet(pts[,1:3])
plotPoints3D(pts[pts$se,1:3], argsPlot3d = list(col = "red"))
plotPoints3D(pts[pts$sne,1:3], argsPlot3d = list(col = "black"))
plotPoints3D(pts[pts$us,1:3], argsPlot3d = list(col = "blue"))
plotCones3D(pts[,1:3], rectangle = TRUE, argsPolygon3d = list(alpha = 1))
finalize3D()
pts

pts <- matrix(c(0,0,1, 0,1,0, 1,0,0, 0.2,0.1,0.1, 0.1,0.45,0.45), ncol = 3, byrow = TRUE)
di <- -1 # maximize
ini3D(argsPlot3d = list(xlim = c(min(pts[,1])-1,max(pts[,1])+1),
  ylim = c(min(pts[,2])-1,max(pts[,2])+1),
  zlim = c(min(pts[,3])-1,max(pts[,3])+1)))
plotHull3D(pts, addRays = TRUE, argsPolygon3d = list(alpha = 0.5), direction = di,
           addText = "coord")
pts <- classifyNDSet(pts[,1:3], direction = di)
plotPoints3D(pts[pts$se,1:3], argsPlot3d = list(col = "red"))
plotPoints3D(pts[pts$sne,1:3], argsPlot3d = list(col = "black"))
plotPoints3D(pts[pts$us,1:3], argsPlot3d = list(col = "blue"))
plotCones3D(pts[,1:3], rectangle = TRUE, argsPolygon3d = list(alpha = 1), direction = di)
finalize3D()
pts

pts <- matrix(c(0,0,1, 0,0,1, 0,1,0, 0.5,0.2,0.5, 1,0,0, 0.5,0.2,0.5, 0.25,0.5,0.25), ncol = 3,
              byrow = TRUE)
classifyNDSet(pts)

pts <- genNDSet(3,15)[,1:3]
ini3D(argsPlot3d = list(xlim = c(0,max(pts$z1)+2),
  ylim = c(0,max(pts$z2)+2),
  zlim = c(0,max(pts$z3)+2)))
plotHull3D(pts[, 1:3], addRays = TRUE, argsPolygon3d = list(alpha = 0.5))
pts <- classifyNDSet(pts[,1:3])
plotPoints3D(pts[pts$se,1:3], argsPlot3d = list(col = "red"))
plotPoints3D(pts[pts$sne,1:3], argsPlot3d = list(col = "black"))
plotPoints3D(pts[pts$us,1:3], argsPlot3d = list(col = "blue"))
finalize3D()
pts

pts <- genNDSet(3, 15, keepDom = FALSE, argsSphere = list(below = FALSE, factor = 10))[,1:3]
ini3D(argsPlot3d = list(xlim = c(0,max(pts$z1)+2),
  ylim = c(0,max(pts$z2)+2),
  zlim = c(0,max(pts$z3)+2)))
plotHull3D(pts[, 1:3], addRays = TRUE, argsPolygon3d = list(alpha = 0.5))
pts <- classifyNDSet(pts[,1:3])
plotPoints3D(pts[pts$se,1:3], argsPlot3d = list(col = "red"))
plotPoints3D(pts[pts$sne,1:3], argsPlot3d = list(col = "black"))
plotPoints3D(pts[pts$us,1:3], argsPlot3d = list(col = "blue"))
finalize3D()
pts
}
}
