% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evidence-joint.R
\name{set-jevidence}
\alias{set-jevidence}
\alias{setJEvi}
\alias{setJEvi_}
\alias{insertJEvi}
\alias{retractJEvi}
\alias{new_jev}
\alias{print.grain_jev}
\title{Set joint evidence in grain objects}
\usage{
setJEvi(object, evidence = NULL, propagate = TRUE, details = 0)

insertJEvi(evi.list, pot, hostclique)

retractJEvi(object, items = NULL, propagate = TRUE, details = 0)

new_jev(ev, levels)

\method{print}{grain_jev}(x, ...)
}
\arguments{
\item{object}{A "grain" object}

\item{evidence}{A list of evidence. Each element is a named array.}

\item{propagate}{Should the network be propagated?}

\item{details}{Debugging information}

\item{evi.list}{A "grain_jev" object.}

\item{pot}{A list of clique potentials (a potential is an array).}

\item{hostclique}{A numerical vector indicating in which element of
'pot' each eviendence item in 'evi.list' should be inserted in.}

\item{items}{Items in the evidence list to be removed. Here,
\code{NULL} means remove everything, \code{0} means nothing is
removed. Otherwise \code{items} is a numeric vector.}

\item{ev}{A named list.}

\item{levels}{A named list.}

\item{x}{A "grain_jev" object.}

\item{...}{Additional arguments; currently not used.}
}
\description{
Setting and removing joint evidence in grain objects.
}
\note{
All the joint evidence functionality should be used \emph{with great care}.
}
\examples{

example("grain")

uni <- list(asia = c("yes", "no"), tub = c("yes", "no"),
            smoke = c("yes", "no"), lung = c("yes", "no"),
            bronc = c("yes", "no"), either = c("yes", "no"),
            xray = c("yes", "no"), dysp = c("yes", "no"))

ev <- list(tab("asia", levels=uni, values=c(1,0)),
           tab("dysp", levels=uni, values=c(1,0)),
           tab(c("dysp","bronc"), levels=uni, values=c(.1, .2, .9, .8)) )

bn2 <- setJEvi(bn, evidence=ev)
bn2

## Notice: The evidence is defined on (subsets of) cliques of the junction tree
# and therefore evidence can readily be absorbed:
getgrain(bn, "rip")$cliques  \%>\% str

## On the other hand, below evidence is not defined cliques of the
# junction tree and therefore evidence can not easily be absorbed.
# Hence this will fail:

\dontrun{
ev.fail <- list(tab(c("dysp","smoke"), levels=uni, values=c(.1, .2, .9, .8)) )
setJEvi(bn, evidence=ev.fail)
}

## Evidence can be removed with

retractJEvi(bn2)    ## All evidence removed.
retractJEvi(bn2, 0) ## No evidence removed.
retractJEvi(bn2, 1:2) ## Evidence items 1 and 2 are removed.

## Setting additional joint evidence to an object where joint
# evidence already is set will cause an error. Hence this will fail:
\dontrun{
  ev2 <- list(smoke="yes")
  setJEvi(bn2, evidence=ev2)
}

## Instead we can do
new.ev <- c( getEvidence(bn2), list(smoke="yes") )
setJEvi( bn, evidence=new.ev )


## Create joint evidence object:

db <- parray(c("dysp","bronc"), list(yn,yn), values=c(.1,.2,.9,.8))
db
ev   <- list(asia=c(1,0), dysp="yes", db)

uni <- list(asia = c("yes", "no"), tub = c("yes", "no"),
  smoke = c("yes", "no"), lung = c("yes", "no"),
  bronc = c("yes", "no"), either = c("yes", "no"),
  xray = c("yes", "no"), dysp = c("yes", "no"))

jevi <- new_jev( ev, levels=uni )
jevi


bn3 <- setJEvi( bn, evidence=jevi)
evidence( bn3 )

}
\references{
Søren Højsgaard (2012). Graphical Independence Networks
with the gRain Package for R. Journal of Statistical Software,
46(10), 1-26.  \url{http://www.jstatsoft.org/v46/i10/}.
}
\seealso{
\code{\link{setFinding}} \code{\link{getFinding}}
\code{\link{retractFinding}} \code{\link{pFinding}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
\keyword{utilities}
