% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-coerce-list.R
\name{graph-coerce-list}
\alias{graph-coerce-list}
\alias{ugl2gn_}
\alias{ugl2ig_}
\alias{ugl2dm_}
\alias{ugl2sm_}
\alias{ugl2XX_}
\alias{dagl2gn_}
\alias{dagl2ig_}
\alias{dagl2dm_}
\alias{dagl2sm_}
\alias{dagl2XX_}
\alias{adl2gn_}
\alias{adl2ig_}
\alias{adl2dm_}
\alias{adl2sm_}
\alias{adl2XX_}
\alias{M2adl_}
\alias{M2ugl_}
\alias{M2dagl_}
\alias{ugl2M_}
\alias{dagl2M_}
\alias{adl2M_}
\title{Coercion of graphs represented as lists}
\usage{
ugl2gn_(glist, vn = NULL)

ugl2ig_(zz, vn = NULL)

ugl2dm_(zz, vn = NULL)

ugl2sm_(zz, vn = NULL)

ugl2XX_(zz, outtype, vn = NULL)

dagl2gn_(glist, vn = NULL)

dagl2ig_(zz, vn = NULL)

dagl2dm_(zz, vn = NULL)

dagl2sm_(zz, vn = NULL)

dagl2XX_(zz, outtype, vn = NULL)

adl2gn_(zz)

adl2ig_(zz)

adl2dm_(zz)

adl2sm_(zz)

adl2XX_(zz, outtype)

M2adl_(amat)

M2ugl_(amat)

M2dagl_(amat)

ugl2M_(glist, vn = NULL, result = "matrix")

dagl2M_(glist, vn = NULL, result = "matrix")

adl2M_(alist, result = "matrix")
}
\arguments{
\item{glist}{A list of generators where a generator is a character
vector. If interpreted as generators of an undirected graph, a
generator is a complete set of vertices in the graph. If
interpreted as generators of a dag, a generator (v1,...,vn)
means that there will be arrows from v2,...,vn to v1.}

\item{vn}{The names of the vertices in the graphs. These will be
the row and column names of the matrix.}

\item{zz}{An object representing a graph.}

\item{outtype}{What should a list be coerced to.}

\item{amat}{Adjacency matrix (dense or sparse dgCMatrix).}

\item{result}{A graph object.}

\item{alist}{An adjacency list.}
}
\description{
Coercion of graphs represented as lists to various
    graph formats.
}
\examples{

## Sparse and dense adjacency matrices converted to adjacency list 
g1 <- ug(~a:b + b:c + c:d, result="matrix")
g2 <- ug(~a:b + b:c + c:d, result="dgCMatrix")
M2adl_( g1 )

## Sparse and dense adjacency matrices converted to cliques
M2ugl_( g1 )

## Sparse and dense adjacency matrices converted to cliques
M2dagl_( g1 )

## M2adl_( g2 ) ## FIXME FAILS for sparse matrix
## M2ugl_( g2 ) ## FIXME Is there an issue here??
## M2dagList( g2 ) ## Fails for sparse matrix

}
