% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcombn.R
\name{fastcombn}
\alias{fastcombn}
\alias{combn_prim}
\title{Generate All Combinations of n Elements Taken m at a Time}
\usage{
fastcombn(x, m, FUN = NULL, simplify = TRUE, ...)

combn_prim(x, m, simplify = TRUE)
}
\arguments{
\item{x}{vector source for combinations, or integer n for x <-
seq(n).}

\item{m}{number of elements to choose.}

\item{FUN}{function to be applied to each combination; default ‘NULL’
means the identity, i.e., to return the combination (vector
of length ‘m’).}

\item{simplify}{logical indicating if the result should be
simplified to a matrix; if FALSE, the function returns a list.}

\item{...}{Further arguments passed on to `FUN`.}
}
\value{
A matrix or a list.
}
\description{
Generate all combinations of the elements of x taken m
    at a time.  If x is a positive integer, returns all
    combinations of the elements of seq(x) taken m at a time.
}
\details{
*  Factors `x` are accepted.

* `combn_prim` is a simplified (but faster) version of the `combn`
   function. Does nok take the `FUN` argument.

* `fastcombn` is intended to be a faster version of the `combn`
   function.
}
\examples{

x <- letters[1:5]; m <- 3

fastcombn(x, m)
combn(x, m)
combn_prim(x, m)

x <- letters[1:4]; m <- 3
fastcombn(x, m, simplify=FALSE)
combn(x, m, simplify=FALSE)
combn_prim(x, m, simplify=FALSE)

x <- 1:10; m <- 3
fastcombn(x, m, min)
combn(x, m, min)

x <- factor(letters[1:8]); m <- 5

if (require(microbenchmark)){
  microbenchmark(
    combn(x, m, simplify=FALSE),
    combn_prim(x, m, simplify=FALSE),
    fastcombn(x, m, simplify=FALSE),
    times=50
  )
}

}
\seealso{
\code{\link{combn}}
}
\author{
Søren Højsgaard
}
\keyword{utilities}
