% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/testing-add1drop1.R
\name{add1-drop1}
\alias{add1-drop1}
\alias{evalInECC}
\alias{evalOutECC}
\alias{add1.rcox}
\alias{drop1.rcox}
\title{Add or drop colour classes to RCOX models}
\usage{
\method{add1}{rcox}(object, scope, details = 0, trace = 0, ...)

\method{drop1}{rcox}(object, scope, details = 0, trace = 0, stat = "wald", ...)
}
\arguments{
\item{object}{An RCOX model, an object of class 'rcox'}

\item{scope}{A set of edge colour classes to be considered for
addition or deletion, see 'details'.}

\item{details}{Control the amount of output created.}

\item{trace}{For debugging purposes}

\item{\dots}{Additional arguments, currently unused.}

\item{stat}{Either "wald" for a Wald statistic or "dev" for a
deviance statistic.}
}
\value{
A list with entries
\itemize{
\item tab: A dataframe with the test results
\item cc: A list of colour classes
}
}
\description{
Make a test for adding/dropping all colour classes in
scope for an RCOX model.
}
\note{
\itemize{
\item Note that the keyword 'stat' is not available for add1
because this function expands the current model and hence the
Wald statistic is not available.
\item Based on fitting a new model for each new ecc, and may hence be slow.
}
}
\examples{

data(math)
gc.sat <- ~me:ve:al:st:an
gc.1   <- ~me+ve+al+st+an

m.sat <- rcox(gm=gc.sat, data=math)
m.1   <- rcox(gm=gc.1,   data=math)

t.sat <- drop1(m.sat)
t.sat$tab
t.sat$cc

t.1   <- add1(m.1)
t.1$tab
t.1$cc
}
\seealso{
\code{\link{comparecc}}, \code{\link{stepadd1}},
\code{\link{stepdrop1}}.
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{htest}
