% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getEdges.R
\name{getEdges}
\alias{getEdges}
\alias{getEdges.list}
\alias{getEdges.graphNEL}
\alias{getEdges.matrix}
\alias{getInEdges}
\alias{getOutEdges}
\alias{getEdgesMAT}
\alias{getInEdgesMAT}
\alias{getOutEdgesMAT}
\title{Find edges in a graph and edges not in an undirected graph.}
\usage{
getEdges(object, type = "unrestricted", ingraph = TRUE, discrete = NULL,
  ...)
}
\arguments{
\item{object}{An object representing a graph; either a generator list, a
graphNEL object or an adjacency matrix.}

\item{type}{Either "unrestricted" or "decomposable"}

\item{ingraph}{If TRUE the result is the edges in the graph; if FALSE the
result is the edges not in the graph.}

\item{discrete}{This argument is relevant only if \code{object} specifies a
marked graph in which some vertices represent discrete variables and some
represent continuous variables.}

\item{\dots}{Additional arguments; currently not used.}
}
\value{
A p * 2 matrix with edges.
}
\description{
Returns the edges of a graph (or edges not in a graph) where the
    graph can be either a graphNEL object, a list of generators or an
    adjacency matrix.
}
\details{
When \code{ingraph=TRUE}: If type="decomposable" then
    \code{getEdges()} returns those edges e for which the graph with e
    removed is decomposable.

When \code{ingraph=FALSE}: Likewise, if type="decomposable" then
\code{getEdges()} returns those edges e for which the graph with e added is
decomposable.

The functions \code{getInEdges()} and \code{getInEdges()} are just wrappers
for calls to \code{getEdges()}.

The workhorses are \code{getInEdgesMAT()} and \code{getOutEdgesMAT()} and
these work on adjacency matrices.

Regarding the argument \code{discrete}, please see the documentation of
\code{\link[gRbase]{mcsmarked}}.
}
\note{
These functions work on undirected graphs. The behaviour is
    undocumented for directed graphs.
}
\examples{

gg     <- ug(~a:b:d + a:c:d + c:e)
glist  <- getCliques(gg)
adjmat <- as.adjMAT(gg)

#### On a glist
getEdges(glist)
getEdges(glist,type="decomposable")
# Deleting (a,d) would create a 4-cycle

getEdges(glist, ingraph=FALSE)
getEdges(glist,type="decomposable", ingraph=FALSE)
# Adding (e,b) would create a 4-cycle

#### On a graphNEL
getEdges(gg)
getEdges(gg,type="decomposable")
# Deleting (a,d) would create a 4-cycle

getEdges(gg, ingraph=FALSE)
getEdges(gg,type="decomposable", ingraph=FALSE)
# Adding (e,b) would create a 4-cycle

#### On an adjacency matrix
getEdges(adjmat)
getEdges(adjmat,type="decomposable")
# Deleting (a,d) would create a 4-cycle

getEdges(adjmat, ingraph=FALSE)
getEdges(adjmat,type="decomposable", ingraph=FALSE)
# Adding (e,b) would create a 4-cycle


## Marked graphs; vertices a,b are discrete; c,d are continuous
UG <- ug(~a:b:c + b:c:d)
disc <- c("a","b")
getEdges(UG)
getEdges(UG, discrete=disc)
## Above: same results; there are 5 edges in the graph

getEdges(UG, type="decomposable")
## Above: 4 edges can be removed and will give a decomposable graph
##(only removing the edge (b,c) would give a non-decomposable model)

getEdges(UG, type="decomposable", discrete=c("a","b"))
## Above: 3 edges can be removed and will give a strongly decomposable
## graph. Removing (b,c) would create a 4--cycle and removing (a,b)
## would create a forbidden path; a path with only continuous vertices
## between two discrete vertices.


}
\seealso{
\code{\link{edgeList}}, \code{\link{nonEdgeList}},
    \code{\link{mcsmarked}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{utilities}
