% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/path.R
\name{path}
\alias{path}
\title{Extract Path Coefficients}
\usage{
path(x, from, to, round = 3)
}
\arguments{
\item{x}{object of class "sgSEMp1", which is the return value of function sgSEMp1().}

\item{from}{character string. Name of the predictor.}

\item{to}{character string. Name of the response variable.}

\item{round}{a positive integer. The coefficients are rounded to this decimal place.}
}
\value{
A list of the following items: 1) model: the best fitted model, 2) model.print: a character string of the model equation and 3) coefs: Model coefficients vector.
}
\description{
Extract and display an equation of a pairwise path between two variables.
}
\details{
Extract the "best" model between any two variables. The model name and the model equation are printed on screen. The model coefficients, as well as the model R object are also returned.
}
\examples{
##' ## Load the sample acrylic data set
data(acrylic)

## Run semi-gSEM principle one
ans <- sgSEMp1(acrylic, predictor = "IrradTot", response = "YI")

## Extract relations between IrradTot and IAD2
cf <- path(ans, from = "IrradTot", to = "IAD2")
print(cf)
}

