% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{add}
\alias{add}
\alias{add.default}
\alias{delete}
\alias{delete.GContainer}
\title{Add a child object to parent container}
\usage{
add(obj, child, expand = FALSE, fill = NULL, anchor = NULL, ...)

\method{add}{default}(obj, child, expand = FALSE, fill = NULL, anchor = NULL, ...)

delete(obj, child)

\method{delete}{GContainer}(obj, child)
}
\arguments{
\item{obj}{parent object}

\item{child}{child widget}

\item{expand}{NULL or logical. For box containers controls whether a child will expand to fill the allocated space.}

\item{fill}{NULL or character. For box containers. The value of \code{fill} (not
always respected) is used to control if expansion happens
vertically (\code{y}), horizontally (\code{x}) or both
(\code{both} or \code{TRUE}). For vertically filled box
containers, children always fill horizontally (atleast) and for
horizontally filled box containers, children always fill
vertically (atleast). This is important to realize when trying to
size buttons, say.}

\item{anchor}{NULL or integer. For box containers. The anchor argument is used to
position the child within the parent when there is more space
allocated than the child requests. This is specified with a
Cartesian pair in {-1,0,1} x {-1, 0, 1}.}

\item{...}{passed on to the}
}
\description{
Add packs in child objects.

Delete may or may not remove a child. This is toolkit
specific. It may also be tied up with garbage collection. To avoid
that, keep a reference to the child object before deleting.
}
