% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filter.R, R/galah_filter.R
\name{filter.data_request}
\alias{filter.data_request}
\alias{galah_filter}
\title{Narrow a query by specifying filters}
\usage{
\method{filter}{data_request}(.data, ...)

galah_filter(..., profile = NULL)
}
\arguments{
\item{.data}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}

\item{...}{filters, in the form \verb{field logical value}}

\item{profile}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#soft-deprecated}{\figure{lifecycle-soft-deprecated.svg}{options: alt='[Soft-deprecated]'}}}{\strong{[Soft-deprecated]}} Use \code{galah_apply_profile} instead.

If supplied, should be a \code{string} recording a data quality profile to
apply to the query. See \code{\link[=show_all_profiles]{show_all_profiles()}} for valid profiles. By
default no profile is applied.}
}
\value{
A tibble containing filter values.
}
\description{
"Filters" are arguments of the form \code{field} \code{logical} \code{value} that are used
to narrow down the number of records returned by a specific query.
For example, it is common for users to request records from a particular year
(\code{year == 2020}), or to return all records except for fossils
(\code{basisOfRecord != "FossilSpecimen"}).

The result of \code{galah_filter()} can be passed to the \code{filter}
argument in \code{\link[=atlas_occurrences]{atlas_occurrences()}}, \code{\link[=atlas_species]{atlas_species()}},
\code{\link[=atlas_counts]{atlas_counts()}} or \code{\link[=atlas_media]{atlas_media()}}.
}
\details{
\code{galah_filter} uses non-standard evaluation (NSE),
and is designed to be as compatible as possible with \code{dplyr::filter()}
syntax.

All statements passed to \code{galah_filter()} (except the \code{profile}
argument) take the form of field - logical - value. Permissible examples include:
\itemize{
\item \code{=} or \code{==} (e.g. \code{year = 2020})
\item \code{!=}, e.g. \code{year != 2020})
\item \code{>} or \code{>=} (e.g. \code{year >= 2020})
\item \code{<} or \code{<=} (e.g. \code{year <= 2020})
\item \code{OR} statements (e.g. \code{year == 2018 | year == 2020})
\item \code{AND} statements (e.g. \code{year >= 2000 & year <= 2020})
}

In some cases \code{R} will fail to parse inputs with a single equals sign
(\code{=}), particularly where statements are separated by \code{&} or
\code{|}. This problem can be avoided by using a double-equals (\code{==}) instead.

\emph{Notes on behaviour}

Separating statements with a comma is equivalent to an \code{AND} statement;
Ergo \code{galah_filter(year >= 2010 & year < 2020)} is the same as
\code{galah_filter(year >= 2010, year < 2020)}.

All statements must include the field name; so
\code{galah_filter(year == 2010 | year == 2021)} works, as does
\code{galah_filter(year == c(2010, 2021))}, but \code{galah_filter(year == 2010 | 2021)}
fails.

It is possible to use an object to specify required values, e.g.
\verb{year_value <- 2010; galah_filter(year > year_value)}

\code{solr} supports range queries on text as well as numbers; so this is valid:
\code{galah_filter(cl22 >= "Tasmania")}
}
\examples{
\dontrun{
# Filter query results to return records of interest
galah_call() |>
  galah_filter(year >= 2019,
               basisOfRecord == "HumanObservation") |>
  atlas_counts()
}

}
\seealso{
\code{\link[=search_taxa]{search_taxa()}} and \code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to restrict
the information returned by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions. Use
\code{search_all(fields)} to find fields that
you can filter by, and \code{\link[=show_values]{show_values()}} to find what values
of those filters are available.
}
