% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_apply_profile.R
\name{galah_apply_profile}
\alias{galah_apply_profile}
\alias{apply_profile}
\title{Apply a data quality profile}
\usage{
galah_apply_profile(...)

apply_profile(.data, ...)
}
\arguments{
\item{...}{a profile name. Should be a \code{string} - the name or abbreviation
of a data quality profile to apply to the query. Valid values can be seen
using \code{show_all(profiles)}}

\item{.data}{An object of class \code{data_request}}
}
\value{
A tibble containing a valid data profile value.
}
\description{
A 'profile' is a group of filters that are pre-applied by the ALA. Using a
data profile allows a query to be filtered quickly to the most relevant or
quality-assured data that is fit-for-purpose. For example, the "ALA" profile
is designed to exclude lower quality records, whereas other profiles apply
filters specific to species distribution modelling (e.g. CDSM).
}
\details{
Note that only one profile can be loaded at a time; if multiple profiles are
given, the first valid profile is used.

For more bespoke editing of filters within a profile, use \code{\link[=galah_filter]{galah_filter()}}
}
\examples{
\dontrun{
# Apply a data quality profile to a query
galah_call() |> 
  galah_identify("reptilia") |>
  galah_filter(year == 2021) |>
  galah_apply_profile(ALA) |>
  atlas_counts()
}
}
\seealso{
\code{\link[=show_all]{show_all()}} and \code{\link[=search_all]{search_all()}} to look up available data profiles.
\code{\link[=galah_filter]{galah_filter()}} can be used for more bespoke editing of individual data
profile filters.
}
