% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_select.R
\name{galah_select}
\alias{galah_select}
\alias{select.data_request}
\title{Specify fields for occurrence download}
\usage{
galah_select(..., group)

\method{select}{data_request}(.data, ..., group)
}
\arguments{
\item{...}{zero or more individual column names to include}

\item{group}{\code{string}: (optional) name of one or more column groups to
include. Valid options are \code{"basic"}, \code{"event"} and
\code{"assertions"}}

\item{.data}{An object of class \code{data_request}, created using \code{\link[=galah_call]{galah_call()}}}
}
\value{
A tibble
specifying the name and type of each column to include in the
call to \code{atlas_counts()} or \code{atlas_occurrences()}.
}
\description{
GBIF and it's partner nodes store content in hundreds of
different fields, and users often require thousands or millions of records at
a time. To reduce time taken to download data, and limit complexity of the
resulting \code{tibble}, it is sensible to restrict the fields returned by
\code{\link[=atlas_occurrences]{atlas_occurrences()}}. This function allows easy selection of fields, or
commonly-requested groups of columns, following syntax shared with
\code{dplyr::select()}.

The full list of available fields can be viewed with \code{show_all(fields)}. Note
that \code{select()} and \code{galah_select()} are supported for all atlases that allow
downloads, with the exception of GBIF, for which all columns are returned.
}
\details{
Calling the argument \code{group = "basic"} returns the following columns:
\itemize{
\item \code{decimalLatitude}
\item \code{decimalLongitude}
\item \code{eventDate}
\item \code{scientificName}
\item \code{taxonConceptID}
\item \code{recordID}
\item \code{dataResourceName}
\item \code{occurrenceStatus}
}

Using \code{group = "event"} returns the following columns:
\itemize{
\item \code{eventRemarks}
\item \code{eventTime}
\item \code{eventID}
\item \code{eventDate}
\item \code{samplingEffort}
\item \code{samplingProtocol}
}

Using \code{group = "media"} returns the following columns:
\itemize{
\item \code{multimedia}
\item \code{multimediaLicence}
\item \code{images}
\item \code{videos}
\item \code{sounds}
}

Using \code{group = "assertions"} returns all quality assertion-related
columns. The list of assertions is shown by \code{show_all_assertions()}.
}
\examples{
\dontrun{
# Download occurrence records of *Perameles*, 
# Only return scientificName and eventDate columns
galah_config(email = "your-email@email.com")
galah_call() |>
  galah_identify("perameles")|>
  galah_select(scientificName, eventDate) |>
  atlas_occurrences()

# Only return the "basic" group of columns and the basisOfRecord column
galah_call() |>
  galah_identify("perameles") |>
  galah_select(basisOfRecord, group = "basic") |>
  atlas_occurrences()
  
# When used in a pipe, `galah_select()` and `select()` are synonymous.
# Hence the previous example can be rewritten as:
request_data() |>
  identify("perameles") |>
  select(basisOfRecord, group = "basic") |>
  collect()
}
}
\seealso{
\code{\link[=search_taxa]{search_taxa()}}, \code{\link[=galah_filter]{galah_filter()}} and
\code{\link[=galah_geolocate]{galah_geolocate()}} for other ways to restrict the information returned
by \code{\link[=atlas_occurrences]{atlas_occurrences()}} and related functions; \code{\link[=atlas_counts]{atlas_counts()}}
for how to get counts by levels of variables returned by \code{galah_select};
\code{show_all(fields)} to list available fields.
}
