% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Comparator-generics.R, R/Comparator-methods.R
\docType{methods}
\name{Comparator}
\alias{Comparator}
\alias{Comparator<-}
\alias{\%starts_with\%}
\alias{\%ends_with\%}
\alias{\%contains\%}
\alias{\%matches\%}
\alias{\%between\%}
\alias{\%in\%}
\alias{\%matches\%,.var,.dimOperand-method}
\alias{\%starts_with\%,.var,.dimOperand-method}
\alias{\%ends_with\%,.var,.dimOperand-method}
\alias{\%contains\%,.var,.dimOperand-method}
\alias{\%between\%,.var,.operand-method}
\alias{\%in\%,.var,.operand-method}
\alias{==,.var,.operand-method}
\alias{!=,.var,.operand-method}
\alias{>,.var,.metOperand-method}
\alias{<,.var,.metOperand-method}
\alias{>=,.var,.metOperand-method}
\alias{<=,.var,.metOperand-method}
\alias{Comparator,.expr-method}
\alias{Comparator<-,.expr-method}
\title{Comparator.}
\usage{
Comparator(object, ...)

Comparator(object) <- value

var \%starts_with\% operand

var \%ends_with\% operand

var \%contains\% operand

var \%matches\% operand

var \%between\% operand

x \%in\% table

\S4method{\%matches\%}{.var,.dimOperand}(var, operand)

\S4method{\%starts_with\%}{.var,.dimOperand}(var, operand)

\S4method{\%ends_with\%}{.var,.dimOperand}(var, operand)

\S4method{\%contains\%}{.var,.dimOperand}(var, operand)

\S4method{\%between\%}{.var,.operand}(var, operand)

\S4method{\%in\%}{.var,.operand}(x, table)

\S4method{==}{.var,.operand}(e1, e2)

\S4method{!=}{.var,.operand}(e1, e2)

\S4method{>}{.var,.metOperand}(e1, e2)

\S4method{<}{.var,.metOperand}(e1, e2)

\S4method{>=}{.var,.metOperand}(e1, e2)

\S4method{<=}{.var,.metOperand}(e1, e2)

\S4method{Comparator}{.expr}(object)

\S4method{Comparator}{.expr}(object) <- value
}
\arguments{
\item{object}{The object to be coerced to a '.Comparator' subclass or the
expression object of which to obtain its comparator.}

\item{...}{Used by certain methods.}

\item{value}{The value to set the comparator to.}

\item{var}{dimension object}

\item{operand}{operand object}

\item{x}{Dimension or metric object}

\item{table}{Operand object}

\item{e1}{Dimension or metric object}

\item{e2}{Operand object}
}
\description{
Get a comparator used in an expression or create a comparator object.

Set the comparator of an expression.
}
\section{Methods (by class)}{
\itemize{
\item \code{.expr}: Return the comparator used within the supplied
conditional expression.

\item \code{.expr}: Replace the comparator of the supplied
conditional expression.
}}

\section{\%starts_with\%}{

A condition where the dimension (LHS) matches values that start with
the character string given by the operand (RHS).
}

\section{\%ends_with\%}{

A condition where the dimension (LHS) matches values that end with
the character string given by the operand (RHS).
}

\section{\%contains\%}{

A condition where the dimension (LHS) matches values that contain
the character string given by the operand (RHS).
}

\section{\%matches\%}{

A condition where the dimension (LHS) matches a regular
expression given by the operand (RHS).
}

\section{\%between\%}{

A condition where the var (LHS) is within the lower and
upper bounds specified by first and second vector value (respectively) of
the operand (RHS).
}

\section{\%in\%}{

A condition where the dimension (LHS) matches one of the
values in the vector specified by the operand (RHS).
}

\concept{comparators}
