% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Expr-generics.R, R/Expr-methods.R
\docType{methods}
\name{McfExpr}
\alias{McfExpr}
\alias{McfExpr,character,character-method}
\title{McfExpr.}
\usage{
McfExpr(object, comparator, operand)

\S4method{McfExpr}{character,character}(object, comparator, operand)
}
\arguments{
\item{object}{A dimension or metric variable, or another object to be coerced
to an .expr object.}

\item{comparator}{The comparator to use for the expression.}

\item{operand}{The operand to use for the expression.}
}
\description{
Create a Multi-Channel Funnel Reporting API expression.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = character,comparator = character}: Return a Multi-channel Funnel condition based on the
supplied arguments describing the variable, comparator and operator.
}}

\examples{
myQuery <- McfQuery(view = 123456789)
source_matches_google <- McfExpr("mcf:source", "~", "google")
TableFilter(myQuery) <- source_matches_google

}
\seealso{
Other expression generators: \code{\link{Expr}},
  \code{\link{GaExpr}}, \code{\link{RtExpr}}
}
\concept{expression generators}
