% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Gargle-class.R
\name{Gargle-class}
\alias{Gargle-class}
\alias{Gargle2.0}
\title{OAuth2 token objects specific to Google APIs}
\description{
\code{Gargle2.0} is based on the \code{\link[httr:Token-class]{Token2.0}} class provided in
httr. The preferred way to create a \code{Gargle2.0} token is through the
constructor function \code{\link[=gargle2.0_token]{gargle2.0_token()}}. Key differences with \code{Token2.0}:
\itemize{
\item The key for a cached \code{Token2.0} comes from hashing the endpoint, app, and
scopes. For the \code{Gargle2.0} subclass, the identifier or key is expanded to
include the email address associated with the token. This makes it easier to
work with Google APIs with multiple identities.
\item \code{Gargle2.0} tokens are cached, by default, below
\code{"~/.R/gargle/gargle-oauth"}, i.e. at the user level. In contrast, the
default location for \code{Token2.0} is \code{./.httr-oauth}, i.e. in current working
directory. \code{Gargle2.0} behaviour makes it easier to reuse tokens across
projects and makes it less likely that tokens are accidentally synced to a
remote location like GitHub or DropBox.
\item Each \code{Gargle2.0} token is cached in its own file. The token cache is a
directory of such files. In contrast, \code{Token2.0} tokens are cached as
components of a list, which is typically serialized to \code{./.httr-oauth}.
}
}
\keyword{internal}
\section{Super classes}{
\code{\link[httr:Token]{httr::Token}} -> \code{\link[httr:Token2.0]{httr::Token2.0}} -> \code{Gargle2.0}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{email}}{Email associated with the token.}

\item{\code{package}}{Name of the package requesting a token. Used in messages.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Gargle2.0$new()}}
\item \href{#method-print}{\code{Gargle2.0$print()}}
\item \href{#method-hash}{\code{Gargle2.0$hash()}}
\item \href{#method-cache}{\code{Gargle2.0$cache()}}
\item \href{#method-load_from_cache}{\code{Gargle2.0$load_from_cache()}}
\item \href{#method-refresh}{\code{Gargle2.0$refresh()}}
\item \href{#method-init_credentials}{\code{Gargle2.0$init_credentials()}}
\item \href{#method-clone}{\code{Gargle2.0$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="httr" data-topic="Token2.0" data-id="can_refresh">}\href{../../httr/html/Token2.0.html#method-can_refresh}{\code{httr::Token2.0$can_refresh()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httr" data-topic="Token2.0" data-id="revoke">}\href{../../httr/html/Token2.0.html#method-revoke}{\code{httr::Token2.0$revoke()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httr" data-topic="Token2.0" data-id="sign">}\href{../../httr/html/Token2.0.html#method-sign}{\code{httr::Token2.0$sign()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httr" data-topic="Token2.0" data-id="validate">}\href{../../httr/html/Token2.0.html#method-validate}{\code{httr::Token2.0$validate()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create a Gargle2.0 token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$new(
  email = gargle_oauth_email(),
  app = gargle_app(),
  package = "gargle",
  credentials = NULL,
  params = list(),
  cache_path = gargle_oauth_cache()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{email}}{Optional email address. See \code{\link[=gargle2.0_token]{gargle2.0_token()}} for full details.}

\item{\code{app}}{An OAuth consumer application.}

\item{\code{package}}{Name of the package requesting a token. Used in messages.}

\item{\code{credentials}}{Exists largely for testing purposes.}

\item{\code{params}}{A list of parameters for \code{\link[httr:init_oauth2.0]{httr::init_oauth2.0()}}. Some we
actively use in gargle: \code{scope}, \code{use_oob}. Most we do not:
\code{user_params}, \code{type}, \code{as_header}, \code{use_basic_auth}, \code{config_init},
\code{client_credentials}.}

\item{\code{cache_path}}{Specifies the OAuth token cache. Read more in
\code{\link[=gargle_oauth_cache]{gargle_oauth_cache()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A Gargle2.0 token.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Print a Gargle2.0 token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Not used.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-hash"></a>}}
\if{latex}{\out{\hypertarget{method-hash}{}}}
\subsection{Method \code{hash()}}{
Generate the email-augmented hash of a Gargle2.0 token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$hash()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-cache"></a>}}
\if{latex}{\out{\hypertarget{method-cache}{}}}
\subsection{Method \code{cache()}}{
Put a Gargle2.0 token into the cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$cache()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-load_from_cache"></a>}}
\if{latex}{\out{\hypertarget{method-load_from_cache}{}}}
\subsection{Method \code{load_from_cache()}}{
(Attempt to) get a Gargle2.0 token from the cache
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$load_from_cache()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-refresh"></a>}}
\if{latex}{\out{\hypertarget{method-refresh}{}}}
\subsection{Method \code{refresh()}}{
(Attempt to) refresh a Gargle2.0 token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$refresh()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-init_credentials"></a>}}
\if{latex}{\out{\hypertarget{method-init_credentials}{}}}
\subsection{Method \code{init_credentials()}}{
Initiate a new Gargle2.0 token
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$init_credentials()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Gargle2.0$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
