% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readwrite_gasanalyzer.R
\name{read_gasexchange}
\alias{read_gasexchange}
\title{Read gas-exchange data from a text file.}
\usage{
read_gasexchange(filename, delim = "\\t")
}
\arguments{
\item{filename}{path to the input file}

\item{delim}{delimiter to use for the file}
}
\value{
a tibble with gas-exchange data
}
\description{
Data stored by \code{\link[=write_gasexchange]{write_gasexchange()}} can be read by this method. The first
row is the header, the second row specify the units. File encoding must be
UTF-16LE (use the export as unicode txt option in Microsoft Excel).
}
\examples{

example <- system.file("extdata//d13C.tsv", package = "gasanalyzer")

# read data
read_gasexchange(example)
}
