% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NDFE.R
\name{NDFE.fit}
\alias{NDFE.fit}
\title{NDFE fit}
\usage{
NDFE.fit(t, C, A = 1, V, serie = "", k = log(0.01), verbose = TRUE,
  plot = FALSE, ...)
}
\arguments{
\item{t}{time values (usually in hours)}

\item{C}{concentration values}

\item{A}{area covered by the chamber}

\item{V}{effective volume of the chamber}

\item{serie}{id of the flux measurement}

\item{k}{starting value for nls function}

\item{verbose}{logical, TRUE prints message after each flux calculation}

\item{plot}{logical, mainly intended for use in \code{\link{gasfluxes}}}

\item{\dots}{further parameters, currently none}
}
\value{
A list of
   \item{f0}{flux estimate}
   \item{f0.se}{standard error of flux estimate}
   \item{f0.p}{p-value of flux estimate}
   \item{C0, tau}{other parameters of the NDFE model}
   \item{AIC}{Akaike information criterion}
   \item{AICc}{Akaike information criterion with small sample correction}
   \item{RSE}{residual standard error (sigma from summary.nls)}
   \item{diagnostics}{error or warning messages}
}
\description{
Fit the the non-steady-state diffusive flux extimator model using the Golub-Pereyra algorithm for partially linear least-squares models.
}
\details{
The NDFE model (Livingston et al., 2006) is \eqn{C(t)=C_0+f_0\tau \frac{A}{V}\left [\frac{2}{\sqrt{\textup{pi}}}\sqrt{t/\tau}+e^{t/\tau}\textup{erfc}(\sqrt{t/\tau})-1\right ]}{C(t)=C0+f0\tau A/V[2/\sqrt(pi)\sqrt{t/\tau}+exp(t/\tau)erfc(\sqrt(t/\tau)-1]}.
To ensure the lower bound \eqn{\tau > 0}, the substituion \eqn{\tau = e^k}{\tau = exp(k)} is used. The resulting reparameterized model is then 
fit using \code{\link{nls}} with \code{algorithm = "plinear"}. 

Note that according to the reference the model is not valid for negative fluxes. Warning: This function does not check if fluxes are positive. It's left to the user to handle negative fluxes.

The default starting value \eqn{k = log(\tau)} assumes that time is in hours. If you use a different time unit, you should adjust it accordingly.

Note that \code{nls} is used internally and thus this function should not be used with artificial "zero-residual" data.
}
\examples{
#a single fit
t <- c(0, 1/3, 2/3, 1)
C <- c(320, 340, 355, 362)
print(fit <- NDFE.fit(t, C, 1, 0.3, "a"))
plot(C ~ t)
curve({fit$C0+fit$f0*fit$tau*1/0.3*(2/sqrt(pi)*sqrt(x/fit$tau)+
      exp(x/fit$tau)*erfc(sqrt(x/fit$tau))-1)}, 
      from = 0, to = 1, add = TRUE)
#note that the flux estimate is very uncertain because 
#there are no data points in the region of high curvature

}
\references{
Livingston, G.P., Hutchinson, G.L., Spartalian, K., 2006. Trace gas emission in chambers: A non-steady-state diffusion model. Soil Sci. Soc. Am. J. 70(5), 1459-1469.
}

