% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gating.R
\name{gating}
\alias{gating}
\title{Gating strategy for mass cytometry data using spatial relative risk functions}
\usage{
gating(
  dat,
  vars,
  n_condition = c(1, 2),
  numerator = TRUE,
  bandw = NULL,
  alpha = 0.05,
  p_correct = "none",
  nbc = NULL,
  plot_gate = FALSE,
  save_gate = FALSE,
  name_gate = NULL,
  path_gate = NULL,
  rcols = c("#FF0000", "#CCCCCC", "#0000FF"),
  lower_lrr = NULL,
  upper_lrr = NULL,
  c1n = NULL,
  c2n = NULL,
  win = NULL,
  ...,
  doplot = lifecycle::deprecated(),
  verbose = lifecycle::deprecated()
)
}
\arguments{
\item{dat}{Input data frame flow cytometry data with the following features (columns): 1) ID, 2) Condition A ID, 3) Condition B ID (optional), and a set of markers.}

\item{vars}{A vector of characters with the name of features (columns) within \code{dat} to use as markers for each gate. See details below.}

\item{n_condition}{A numeric value of either 1 or 2 designating if the gating is performed with one condition or two conditions.}

\item{numerator}{Logical. If \code{TRUE} (the default), cells will be extracted within all statistically significant numerator (i.e., case) clusters. If \code{FALSE}, cells will be extracted within all statistically significant denominator (i.e., control) clusters.}

\item{bandw}{Optional, numeric. Fixed bandwidth for the kernel density estimation. Default is based on the internal \code{[sparr]{OS}} function.}

\item{alpha}{Numeric. The two-tailed alpha level for significance threshold (default is 0.05).}

\item{p_correct}{Optional. Character string specifying whether to apply a correction for multiple comparisons including a False Discovery Rate \code{p_correct = "FDR"}, a spatially dependent Sidak correction \code{p_correct = "correlated Sidak"}, a spatially dependent Bonferroni correction \code{p_correct = "correlated Bonferroni"}, an independent Sidak correction \code{p_correct = "uncorrelated Sidak"}, an independent Bonferroni correction \code{p_correct = "uncorrelated Bonferroni"}, and a correction based on Random Field Theory using an equation by Adler and Hasofer \code{p_correct = "Adler and Hasofer"} or an equation by Friston et al. \code{p_correct = "Friston"}. If \code{p_correct = "none"} (the default), then no correction is applied.}

\item{nbc}{Optional. An integer for the number of bins when \code{p_correct = "correlated"}. Similar to \code{nbclass} argument in \code{\link[SpatialPack]{modified.ttest}}. The default is 30.}

\item{plot_gate}{Logical. If \code{TRUE}, the output includes basic data visualizations.}

\item{save_gate}{Logical. If \code{TRUE}, the output saves each visualization as a separate PNG file.}

\item{name_gate}{Optional, character. The filename of the visualization(s). The default is "gate_k" where "k" is the gate number.}

\item{path_gate}{Optional, character. The path of the visualization(s). The default is the current working directory.}

\item{rcols}{Character string of length three (3) specifying the colors for: 1) group A (numerator), 2) neither, and 3) group B (denominator) designations. The defaults are \code{c("#FF0000", "#cccccc", "#0000FF")} or \code{c("red", "grey80", "blue")}.}

\item{lower_lrr}{Optional, numeric. Lower cut-off value for the log relative risk value in the color key (typically a negative value). The default is no limit and the color key will include the minimum value of the log relative risk surface.}

\item{upper_lrr}{Optional, numeric. Upper cut-off value for the log relative risk value in the color key (typically a positive value). The default is no limit and the color key will include the maximum value of the log relative risk surface.}

\item{c1n}{Optional, character. The name of the level for the numerator of condition A. The default is null and the first level is treated as the numerator.}

\item{c2n}{Optional, character. The name of the level for the numerator of condition B. The default is null and the first level is treated as the numerator.}

\item{win}{Optional. Object of class \code{owin} for a custom two-dimensional window within which to estimate the surfaces. The default is NULL and calculates a convex hull around the data.}

\item{...}{Arguments passed to \code{\link[sparr]{risk}} to select resolution.}

\item{doplot}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{doplot} is no longer supported and has been renamed \code{plot_gate}.}

\item{verbose}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{verbose} is no longer supported; this function will not display verbose output from internal \code{\link[sparr]{risk}} function.}
}
\value{
An object of class \code{list}. This is a named list with the following components:

\describe{
\item{\code{obs}}{An object of class 'tibble' of the same features as \code{dat} that includes the information for the cells extracted with significant clusters in the final gate.}
\item{\code{n}}{An object of class 'list' of the sample size of cells at each gate. The length is equal to the number of successful gates plus the final result.}
\item{\code{gate}}{An object of class 'list' of 'rrs' objects from each gate. The length is equal to the number of successful gates.}
\item{\code{note}}{An object of class 'character' of the gating diagnostic message.}
}

The objects of class 'rrs' is similar to the output of the \code{\link[sparr]{risk}} function with two additional components:
\describe{
\item{\code{rr}}{An object of class 'im' with the relative risk surface.}
\item{\code{f}}{An object of class 'im' with the spatial density of the numerator.}
\item{\code{g}}{An object of class 'im' with the spatial density of the denominator.}
\item{\code{P}}{An object of class 'im' with the asymptotic p-value surface.}
\item{\code{lrr}}{An object of class 'im' with the log relative risk surface.}
\item{\code{alpha}}{A numeric value for the alpha level used within the gate.}
}
}
\description{
Extracts cells within statistically significant combinations of fluorescent markers, successively, for a set of markers. Statistically significant combinations are identified using two-tailed p-values of a relative risk surface assuming asymptotic normality. This function is currently available for two-level comparisons of a single condition (e.g., case/control) or two conditions (e.g., case/control at time 1 and time 2). Provides functionality for basic visualization and multiple testing correction.
}
\details{
This function performs a sequential gating strategy for mass cytometry data comparing two levels with one or two conditions. Gates are typically two-dimensional space comprised of two fluorescent markers. The two-level comparison allows for the estimation of a spatial relative risk function and the computation of p-value based on an assumption of asymptotic normality. Cells within statistically significant areas are extracted and used in the next gate. This function relies heavily upon the \code{\link[sparr]{risk}} function. Basic visualization is available if \code{plot_gate = TRUE}.

The \code{vars} argument must be a vector with an even-numbered length where the odd-numbered elements are the markers used on the x-axis of a gate and the even-numbered elements are the markers used on the y-axis of a gate. For example, if \code{vars = c("V1", "V2", "V3", and "V4")} then the first gate is "V1" on the x-axis and "V2" on the y-axis and then the second gate is V3" on the x-axis and "V4" on the y-axis. Makers can be repeated in successive gates.

The \code{n_condition} argument specifies if the gating strategy is performed for one condition or two conditions. If \code{n_condition = 1}, then the function performs a one condition gating strategy using the internal \code{rrs} function, which computes the statistically significant areas (clusters) of a relative risk surface at each gate and selects the cells within the clusters specified by the \code{numerator} argument. If \code{n_condition = 2}, then the function performs a two conditions gating strategy using the internal \code{lotrrs} function, which computes the statistically significant areas (clusters) of a ratio of relative risk surfaces at each gate and selects the cells within the clusters specified by the \code{numerator} argument. The condition variable(s) within \code{dat} must be of class 'factor' with two levels. The first level is considered the numerator (i.e., "case") value and the second level is considered the denominator (i.e., "control") value. The levels can also be specified using the \code{c1n} and \code{c2n} parameters. See the documentation for the internal \code{rrs} and \code{lotrrs} functions for more details.

The p-value surface of the ratio of relative risk surfaces is estimated assuming asymptotic normality of the ratio value at each gridded knot. The bandwidth is fixed across all layers.

Provides functionality for a correction for multiple testing. If \code{p_correct = "FDR"}, calculates a False Discovery Rate by Benjamini and Hochberg. If \code{p_correct = "uncorrelated Sidak"}, calculates an independent Sidak correction. If \code{p_correct = "uncorrelated Bonferroni"}, calculates an independent Bonferroni correction. If \code{p_correct = "correlated Sidak"} or if \code{p_correct = "correlated Bonferroni"}, then the corrections take into account the into account the spatial correlation of the surface. (NOTE: If \code{p_correct = "correlated Sidak"} or if \code{p_correct = "correlated Bonferroni"}, it may take a considerable amount of computation resources and time to calculate). If \code{p_correct = "Adler and Hasofer"} or if \code{p_correct = "Friston"}, then calculates a correction based on Random Field Theory. If \code{p_correct = "none"} (the default), then the function does not account for multiple testing and uses the uncorrected \code{alpha} level. See the internal \code{pval_correct} function documentation for more details.
}
\examples{
if (interactive()) {
## Single condition, no multiple testing correction
  test_gate <- gating(dat = randCyto,
                      vars = c("arcsinh_CD4", "arcsinh_CD38",
                               "arcsinh_CD8", "arcsinh_CD3"),
                      n_condition = 1)
}

}
