% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/froblmmdch.R
\name{frmch}
\alias{frmch}
\title{Robust selection of covariates based on all subsets}
\usage{
frmch(y,x,cn=1,p0=0.01,sg=0,ind=0,sl=T,of=T,xof=F)
}
\arguments{
\item{y}{Dependent variable}

\item{x}{Covariates}

\item{cn}{Constant  for Huber's psi-function}

\item{p0}{The P-value cut-off}

\item{sg}{The scale parameter}

\item{ind}{The subset for which the results are required}

\item{sl}{Logical, if TRUE remove all subsets of chosen sets}

\item{of}{Logical if TRUE include intercept}

\item{xof}{ Logical If TRUE intercept already included}
}
\value{
nv  List of subsets with number of covariates and scale.
}
\description{
Calculates all possible subsets and selects those where each included covariate is significant using a robustified version of flmmdch.R 
}
\examples{
data(boston)
a<-frmch(boston[,14],boston[,1:10])
ind<-decode(235,10)
}
