% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dynamic_feeds.R
\name{get_station_status}
\alias{get_station_status}
\title{Save the station_status feed.}
\usage{
get_station_status(city, directory, file = "station_status.rds")
}
\arguments{
\item{city}{A character string or a url to an active gbfs.json feed. See \code{get_gbfs_cities}
for a current list of available cities.}

\item{directory}{The name of an existing folder or folder to be created, where the feed will
will be saved.}

\item{file}{The name of an existing file or new file to be saved. Must end in .rds.}
}
\value{
A .rds object generated from the current station_status feed.
}
\description{
If the specified file does not exist, \code{get_station_status} saves the station_status
feed for a given city as a .rds object. If the specified file does exist, \code{get_station_status}
appends the current station_status feed to the existing file. Go to 
`https://github.com/NABSA/gbfs/blob/master/gbfs.md` to see metadata for this dataset.
}
\examples{
\donttest{get_station_status(city = 
"http://biketownpdx.socialbicycles.com/opendata/station_status.json", directory = tempdir())}
}
